/////////////////////////////////////////////////////////////////////////////
// Name:        VideoFrameDlg.h
// Purpose:     The video frame dialog
// Author:      Alex Thuering
// Created:     23.12.2011
// RCS-ID:      $Id: VideoFrameDlg.h,v 1.2 2012/06/17 12:01:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef VIDEOFRAME_DLG_H
#define VIDEOFRAME_DLG_H

//(*Headers(VideoFrameDlg)
#include <wx/bmpbuttn.h>
#include <wx/spinctrl.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/spinbutt.h>
#include <wx/slider.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)
#include "mediactrl_ffmpeg.h"

class VideoFrameDlg: public wxDialog {
public:
	VideoFrameDlg(wxWindow* parent, wxString fileName, bool custom, long defaultPos, long pos, int duration);
	virtual ~VideoFrameDlg();
	long GetPos() { return m_pos; }
	int GetDuration() { return m_durationCtrl->GetValue(); }

private:
	//(*Declarations(VideoFrameDlg)
	wxTextCtrl* m_timeCtrl;
	MediaCtrlFF* m_mediaCtrl;
	wxSlider* m_slider;
	wxSpinButton* m_timeSpinBt;
	wxSpinCtrl* m_durationCtrl;
	wxBitmapButton* m_resetTimeBt;
	//*)

	//(*Identifiers(VideoFrameDlg)
	static const long ID_MEDIA_CTRL;
	static const long ID_SLIDER;
	static const long ID_STATICTEXT1;
	static const long ID_TIME_CTRL;
	static const long ID_TIME_SPINB;
	static const long ID_RESET_TIME_BT;
	static const long ID_STATICTEXT2;
	static const long ID_DURATION_CTRL;
	static const long ID_STATICTEXT3;
	//*)

	//(*Handlers(VideoFrameDlg)
	void OnSliderScroll(wxScrollEvent& event);
	void OnTimeSpin(wxSpinEvent& event);
	void OnChangeTime(wxCommandEvent& event);
	void OnResetBt(wxCommandEvent& event);
	//*)
	
	long m_pos;
	long m_defaultPos;
	void SeekVideo(long pos, bool updateTimeCtrl = true);
	DECLARE_EVENT_TABLE()
};

#endif
