/////////////////////////////////////////////////////////////////////////////
// Name:        VideoPropDlg.h
// Purpose:     The video properties dialog
// Author:      Alex Thuering
// Created:     09.09.2010
// RCS-ID:      $Id: VideoPropDlg.h,v 1.9 2011/08/01 20:30:08 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef VIDEO_PROP_DLG_H
#define VIDEO_PROP_DLG_H

#include "Pgc.h"
#include "mediactrl_ffmpeg.h"

// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
#include <wx/spinbutt.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade


class VideoPropDlg: public wxDialog {
public:
    // begin wxGlade: VideoPropDlg::ids
    // end wxGlade
	
	/** Constructor */
	VideoPropDlg(wxWindow* parent, Vob* vob, AspectRatio aspectRatio);
    
    /** Displays dialog */
	virtual int ShowModal();
	
	/** Returns selected video format */
    VideoFormat GetVideoFormat();
    
	/** Returns selected aspect ratio */
    AspectRatio GetAspectRatio();
    
private:
    // begin wxGlade: VideoPropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    // begin wxGlade: VideoPropDlg::attributes
    wxStaticBox* m_cropBox_staticbox;
    wxStaticBox* m_padBox_staticbox;
    wxStaticText* m_fileNameLabel;
    wxStaticText* m_fileNameText;
    wxStaticText* m_durLabel;
    wxStaticText* m_durText;
    wxStaticText* m_srcLabel;
    wxStaticText* m_srcText;
    wxStaticText* m_dstLabel;
    wxChoice* m_dstChoice;
    wxChoice* m_aspectChoice;
    wxChoice* m_interlacedChoice;
    wxChoice* m_ffChoice;
    wxCheckBox* m_keepAspectCtrl;
    wxSpinCtrl* m_padTop;
    wxSpinCtrl* m_padLeft;
    wxSpinCtrl* m_padRight;
    wxSpinCtrl* m_padBottom;
    wxSpinCtrl* m_cropTop;
    wxSpinCtrl* m_cropLeft;
    wxSpinCtrl* m_cropRight;
    wxSpinCtrl* m_cropBottom;
    wxStaticText* m_fadeInLabel;
    wxSpinCtrl* m_fadeInCtrl;
    wxStaticText* m_fadeInLabel2;
    wxStaticText* m_fadeOutLabel;
    wxSpinCtrl* m_fadeOutCtrl;
    wxStaticText* m_fadeOutLabel2;
    wxStaticText* m_filtersLabel;
    wxTextCtrl* m_filtersCtrl;
    MediaCtrlFF* m_mediaCtrl;
    wxSlider* m_slider;
    wxStaticText* m_timeLabel;
    wxTextCtrl* m_timeCtrl;
    wxSpinButton* m_timeSpinBt;
    wxStaticText* m_startLabel;
    wxTextCtrl* m_startCtrl;
    wxBitmapButton* m_startBt;
    wxStaticText* m_endLabel;
    wxTextCtrl* m_endCtrl;
    wxBitmapButton* m_endBt;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    Vob* m_vob;
    Stream* m_stream;
    AspectRatio m_aspectRatio;
    VideoFormat m_lastFormat;
    vector<int> GetPad();
    vector<int> GetCrop();
    void UpdatePad();
    void SeekVideo(long pos, bool updateTimeCtrl = true);
    virtual void OnChangeFormat(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnInterlaced(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeAspect(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeKeepAspect(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeBorder(wxSpinEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeCrop(wxSpinEvent &event); // wxGlade: <event_handler>
    virtual void OnSliderScroll(wxScrollEvent &event); // wxGlade: <event_handler>
    virtual void OnStartBt(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnEndBt(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnOkBt(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnChangeTime(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnTimeSpin(wxSpinEvent &event); // wxGlade: <event_handler>
    
protected:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // VIDEO_PROP_DLG_H
