/////////////////////////////////////////////////////////////////////////////
// Name:        AudioPropDlg.h
// Purpose:     The audio properties dialog
// Author:      Alex Thuering
// Created:     23.07.2011
// RCS-ID:      $Id: AudioPropDlg.h,v 1.7 2013/10/25 20:47:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef AUDIO_PROP_DLG_H
#define AUDIO_PROP_DLG_H

#include "DVD.h"

//(*Headers(AudioPropDlg)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/choice.h>
#include <wx/dialog.h>
#include <wx/spinbutt.h>
//*)

class AudioPropDlg: public wxDialog {
public:
	AudioPropDlg(wxWindow* parent,Vob* vob, const wxString& audioFile, const wxString& langCode, int streamIdx);
	virtual ~AudioPropDlg();
	
    /** Returns selected audio format */
    AudioFormat GetAudioFormat();
    
    /** Returns selected language code */
    wxString GetLangCode();
	
private:
	//(*Declarations(AudioPropDlg)
	wxTextCtrl* m_filtersCtrl;
	wxChoice* m_langChoice;
	wxStaticText* m_durText;
	wxCheckBox* m_audio51;
	wxTextCtrl* m_volumeCtrl;
	wxSpinButton* m_offsetSpin;
	wxSpinButton* m_volumeSpin;
	wxTextCtrl* m_offsetCtrl;
	wxChoice* m_dstChoice;
	wxStaticText* m_fileNameText;
	wxStaticText* m_srcText;
	//*)
	
	//(*Identifiers(AudioPropDlg)
	static const long ID_STATICTEXT1;
	static const long ID_STATICTEXT2;
	static const long ID_STATICTEXT3;
	static const long ID_STATICTEXT4;
	static const long ID_STATICTEXT5;
	static const long ID_STATICTEXT6;
	static const long ID_STATICTEXT7;
	static const long ID_DST_CHOICE;
	static const long ID_A51_CHECK;
	static const long ID_STATICTEXT8;
	static const long ID_LANG_CHOICE;
	static const long ID_STATICTEXT9;
	static const long ID_VOLUME_CTRL;
	static const long ID_SPINBUTTON1;
	static const long ID_STATICTEXT10;
	static const long ID_TEXTCTRL1;
	static const long ID_SPINBUTTON2;
	static const long ID_STATICTEXT11;
	static const long ID_TEXTCTRL2;
	//*)
	
	//(*Handlers(AudioPropDlg)
	void OnChangeFormat(wxCommandEvent& event);
	void OnChangeVolume(wxCommandEvent& event);
	void OnVolumeSpin(wxSpinEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnChangeOffset(wxCommandEvent& event);
	void OnOffsetSpin(wxSpinEvent& event);
	//*)
	
    Vob* m_vob;
    wxString m_audioFile;
    wxString m_langCode;
    Stream* m_stream;

	DECLARE_EVENT_TABLE()
};

#endif
