/////////////////////////////////////////////////////////////////////////////
// Name:        Stream.cpp
// Purpose:     The class to store stream information
// Author:      Alex Thuering
// Created:     25.10.2013
// RCS-ID:      $Id: Stream.cpp,v 1.3 2013/10/25 21:46:51 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "Stream.h"
#include <wx/intl.h>

Stream::Stream(StreamType type, wxString codecName) {
	m_type = type;
	m_sourceCodecName = codecName;
	m_sourceBitrate = 0;
	m_sourceSampleRate = 0;
	m_sourceChannelNumber = -1;
	m_sourceAspectRatio = -1;
	m_sourceFps = -1;
	m_destinationFormat = 1; // vfCOPY/afCOPY/sfCOPY
	m_audioVolume = 1.0;
	m_channelNumber = -1;
	m_tsOffset = 0;
}

VideoFormat Stream::GetSourceVideoFormat() {
	int fps = lround(m_sourceFps);
	if (m_sourceVideoSize.GetWidth() == 720 && m_sourceVideoSize.GetHeight() == 576 && fps == 25)
		return vfPAL;
	else if (m_sourceVideoSize.GetWidth() == 720 && m_sourceVideoSize.GetHeight() == 480 && (fps == 24 || fps == 30))
		return vfNTSC;
	return vfNONE;
}

AudioFormat Stream::GetSourceAudioFormat() {
	if (m_sourceCodecName == wxT("mp2"))
		return afMP2;
	else if (m_sourceCodecName == wxT("liba52") || m_sourceCodecName == wxT("ac3")
			|| m_sourceCodecName == wxT("ac-3"))
		return afAC3;
	return afNONE;
}

wxString Stream::GetSourceFormat() {
	wxString result = m_sourceCodecName;
	if (result == wxT("liba52") || m_sourceCodecName == wxT("ac-3"))
		result = wxT("ac3");
	else if (result.StartsWith(wxT("mpeg2video")))
		result = wxT("mpeg2");
	switch (m_type) {
	case stVIDEO:
		if (m_sourceVideoSize.IsFullySpecified()) {
			result += wxString::Format(wxT(", %dx%d"), m_sourceVideoSize.GetWidth(), m_sourceVideoSize.GetHeight());
			int fps = lround(m_sourceFps);
			if (fps == 25)
				result += wxT(" (PAL)");
			else if (fps == 30)
				result += wxT(" (NTSC)");
			else if (fps == 24)
				result += wxT(" (NTSC film)");
			else if (fps > 0)
				result += wxString::Format(wxT(" (%d fps)"), fps);
			if (round(GetSourceAspectRatio()*100) == 133 || round(GetSourceAspectRatio()*100) == 136)
				result += wxT(", 4:3");
			else if (round(GetSourceAspectRatio()*100) == 178)
				result += wxT(", 16:9");
			else
				result += wxString::Format(wxT(", 1:%0.2f"), GetSourceAspectRatio());
		}
		break;
	case stAUDIO:
		if (m_sourceChannelNumber > 0) {
			result += wxT(", ");
			if (m_sourceChannelNumber == 1)
				result += _("mono");
			else if (m_sourceChannelNumber == 2)
				result += _("stereo");
			else if (m_sourceChannelNumber == 6)
				result += wxT("5.1");
			else
				result += wxString::Format(_("%d channels"), m_sourceChannelNumber);
		}
		if (m_sourceSampleRate)
			result += wxT(", ") + wxString::Format(_("%d Hz"), m_sourceSampleRate);
		break;
	default:
		break;
	}
	return result;
}

/** Returns all audio filters (incl. volume, up- and downmix) */
wxString Stream::GetAllAudioFilters() {
	wxString result;
	if (GetAudioVolume() != 1.0)
		result = wxString::Format(wxT("volume=%0.2f"), GetAudioVolume());
	if (GetDestinationFormat() >= afAC3 && GetChannelNumber() > 0) {
		if (result.length())
			result += wxT(',');
		if (GetChannelNumber() == 6)
			result += wxT("aformat=channel_layouts=5.1,pan=5.1|c0=c0|c1=c1|c2=0.5*c0+0.5*c1|c3=c3|c4=c4|c5=c5");
		else
			result += wxString::Format(wxT("aformat=channel_layouts=%d"), GetChannelNumber());
	}
	if (GetFilters().length()) {
		if (result.length())
			result += wxT(',');
		result += GetFilters();
	}
	return result;
}
