/////////////////////////////////////////////////////////////////////////////
// Name:        mediatrc_ffmpeg.h
// Purpose:     FFMPEG Media Transcoder
// Author:      Alex Thuering
// Created:     26.04.2008
// RCS-ID:      $Id: mediatrc_ffmpeg.h,v 1.35 2014/03/31 08:36:22 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_FFMPEG_MEDIA_TRANSCODER_H
#define WX_FFMPEG_MEDIA_TRANSCODER_H

#include "mediatrc.h"
#include <stdint.h>
#include <math.h>
#include <map>

class wxFfmpegMediaTranscoder : public wxMediaTranscoder {
public:
	wxFfmpegMediaTranscoder(int threadCount = 1);
	~wxFfmpegMediaTranscoder();
	static void Init();
	
	/** Adds input file. */
	bool AddInputFile(const wxString& fileName, const wxString& format = wxT(""), long tsOffset = 0);
	
	/** Sets output file and video/audio/subtitle formats. */
	bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, AspectRatio aspectRatio,
			AudioFormat audioFormat, SubtitleFormat subtitleFormat, int videoBitrate = 6000, bool vbr = false,
			int audioBitrate = 224, int mapFileIdx = -1, int mapStreamIdx = -1);
	/** Sets output file and video/audio/subtitle formats. */
	bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, AspectRatio aspectRatio, 
			wxArrayInt audioFormats, wxArrayInt subtitleFormats, int videoBitrate = 6000, bool vbr = false,
			int audioBitrate = 224, int mapFileIdx = -1, int mapStreamIdx = -1);
	/** Sets output format (optional). Call it before SetOutputFile() */
	void SetOutputFormat(wxString outputFormat) { m_outputFormat = outputFormat; }
	/** Sets interlaced encoding flag */
	void SetInterlaced(bool value);
	/** Sets first field flag (Auto, TFF, BFF) */
	void SetFirstField(FirstField firstField);
	/** Sets start time */
	void SetStartTime(double startTime);
	/** Sets recording time */
	void SetRecordingTime(double recordingTime);
	/** Sets video filters */
	void SetVideoFilters(const wxString& videoFilters) { m_videoFilters = videoFilters; }
	/** Sets audio filters */
	void SetAudioFilters(int streamIndex, const wxString& audioFilters) { m_audioFilters[streamIndex] = audioFilters; }
	
	/** Starts transcoding. */
	bool Run(bool& canceled);
	/** Ends ttanscoding and closes all fiies. */
	void End();
	
	const wxString& GetCmd() const { return m_cmd; }
private:
	unsigned int m_threadCount;
	unsigned int m_inputFileCount;
	wxString m_cmd;
	wxString m_outputFormat;
	wxString m_videoFilters;
    map<int, wxString> m_audioFilters; // stream index -> audio filters
    void AddOption(const wxString& name, const wxString& value);
    void AddAudioOption(const wxString& name, int streamIdx, const wxString& value);
    void AddVideoOption(const wxString& name, int streamIdx, const wxString& value);
    void AddSubtitleOption(const wxString& name, int streamIdx, const wxString& value);
};

#endif // WX_FFMPEG_MEDIA_TRANSCODER_H
