%{
#include <iostream>
#include <string>

#include "conf_analysis_yy.h"

char name_index[500]="";
char section_name[500];
char parameter_name[500];
char parameter_value[1000];
int token_type=TOKEN_NULL;


%}

digit	[0-9]
ident	^[^[:space:]^=^\[.]*
value	.*$
equal	[[:space:]]*"="[[:space:]]*

%s expect_ident
%s expect_index
%s expect_index_value
%s expect_index_end
%s expect_equal
%s expect_value
%s expect_section
%s expect_section_end

%%
<*>^"["/.*			BEGIN(expect_section);
<expect_section>.+/"]"		BEGIN(expect_section_end);	strcpy(section_name,yytext);token_type=TOKEN_SECTION;return 1;
<expect_section_end>.*$		BEGIN(INITIAL);token_type=TOKEN_NULL;
<*>^#.*				BEGIN(INITIAL);token_type=TOKEN_NULL;
<*>{ident}/"["			BEGIN(expect_index);		strcpy(parameter_name,yytext);token_type=TOKEN_NULL;
<*>{ident}/{equal}		BEGIN(expect_equal);		strcpy(name_index,"");strcpy(parameter_name,yytext);token_type=TOKEN_NULL;
<expect_index>"["		BEGIN(expect_index_value);token_type=TOKEN_NULL;
<expect_index_value>.+/"]"	BEGIN(expect_index_end);	strcpy(name_index,yytext);token_type=TOKEN_NULL;
<expect_index_end>"]"		BEGIN(expect_equal);token_type=TOKEN_NULL;
<expect_equal>{equal}$		BEGIN(INITIAL);token_type=TOKEN_NULL;
<expect_equal>{equal}		BEGIN(expect_value);token_type=TOKEN_NULL;
<expect_value>{value}		BEGIN(INITIAL);			strcpy(parameter_value,yytext);token_type=TOKEN_PARAMETER;return 1;
.				BEGIN(INITIAL);token_type=TOKEN_NULL;
\n				BEGIN(INITIAL);token_type=TOKEN_NULL;
%%
int yywrap() { return 1; }

