/*********************************************************************************************************
DVR, Digital Video Recorder - a tool to record movies (audio/video), using realtime compression

It uses libavifile (see http://divx.euro.ru) and some code from kwintv (see wenk@mathematik.uni-kl.de)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation, etc.
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY, etc.

copyright(C) february 2001, Pierre Hbert (pierre.hebert@netcourrier.com)
*********************************************************************************************************/
#include <iostream>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlabel.h>

#include "QTVConfigImpl.h"
#include "v4l.h"

QTVConfigImpl::QTVConfigImpl( QWidget* parent,  const char* name) : QTVConfig( parent, name ) {}


void QTVConfigImpl::setV4L(V4L *v) {
  v4l=v;
  buttons=new (QRadioButton*)[v4l->videoChannels().size()];
  qbg_video_source->setColumnLayout(0, Qt::Vertical );
  QVBoxLayout *qbg_video_sourceLayout = new QVBoxLayout( qbg_video_source->layout() );

  qbg_video_sourceLayout->setAlignment( Qt::AlignTop );
  qbg_video_sourceLayout->setSpacing( 6 );
  qbg_video_sourceLayout->setMargin( 11 );

  for(unsigned long c=0; c<v4l->videoChannels().size(); c++) {
		buttons[c]=new QRadioButton(qbg_video_source, QString(v4l->videoChannels()[c].name));
		buttons[c]->setText(QString(v4l->videoChannels()[c].name));
		buttons[c]->setBackgroundOrigin(ParentOrigin);
		connect(buttons[c], SIGNAL(clicked()), this, SLOT(changeParameter()));
		qbg_video_sourceLayout->addWidget(buttons[c]);
		if(v4l->currentVideoChannel()==c) buttons[c]->toggle();
	}

	QRadioButton *b[4]={ qrb_pal, qrb_ntsc, qrb_secam, qrb_auto };
	for(int c=0; c<4; c++) {
		if(v4l->videoChannels()[v4l->currentVideoChannel()].norm==c) {
      b[c]->toggle();
      break;
    }
	}

	qlb_video_device->setText(v->deviceName()+" ("+v->deviceFileName()+")");
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QTVConfigImpl::~QTVConfigImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void QTVConfigImpl::setChannelList(QList<pair<QString*, unsigned long> > *cl, const QString &cc) {
	unsigned long freq;
  if(v4l->hasTuner()) {
    freq=v4l->tunerFrequency();
  } else {
    freq=0;
  }
	
	channels=cl;
	current_channel=cc;
	pair<QString*, unsigned long> *e;
	for(e=channels->first(); e!=0; e=channels->next()) {
		qlb_channels->insertItem(*(e->first));
		if(freq==e->second) {
			qle_channel_name->setText(current_channel);
		}
	}
	
	qlb_channels->sort();
}

int QTVConfigImpl::getChannel() const {
	for(unsigned long c=0; c<v4l->videoChannels().size(); c++) {
		if(buttons[c]->isChecked()) return c;
	}
	return 0;
}

int QTVConfigImpl::getNorm() const {
	QRadioButton *b[4]={ qrb_pal, qrb_ntsc, qrb_secam, qrb_auto };
	for(int c=0; c<4; c++) {
		if(b[c]->isChecked()) return c;
	}
	return 0;
}

void QTVConfigImpl::changeParameter() {
	emit(parameterChanged());
}

void QTVConfigImpl::addCurrentChannel() {
	unsigned long freq=v4l->tunerFrequency();
	
	pair<QString*, unsigned long> *e;
	bool found=false;
	for(e=channels->first(); e!=0; e=channels->next()) {
		if(e->second==freq) {
			//new element
			pair<QString*, unsigned long> *n=new pair<QString*, unsigned long>;
			n->first=new QString(qle_channel_name->text());
			n->second=freq;
			
			//update the list box
			for(unsigned int i=0; i<qlb_channels->count(); i++) {
				if(qlb_channels->text(i)==*(e->first)) {
					qlb_channels->removeItem(i);
					qlb_channels->insertItem(*(n->first));
					break;
				}
			}
			
			//update the channel list
			delete e->first;
			channels->remove(e);
			channels->append(n);
			
			found=true;
			break;
		}
	}
	if(!found) {
		e=new pair<QString*, unsigned long>;
		e->first=new QString(qle_channel_name->text());
		e->second=freq;
		channels->append(e);
		qlb_channels->insertItem(*(e->first));
	}
	
	qlb_channels->sort();
}

void QTVConfigImpl::removeCurrentChannel() {
	pair<QString*, unsigned long> *e;
	for(e=channels->first(); e!=0; e=channels->next()) {
		if(*(e->first)==qle_channel_name->text()) {
			delete e->first;
			channels->remove();
			break;
		}
	}
	
	for(unsigned int i=0; i<qlb_channels->count(); i++) {
		if(qlb_channels->text(i)==qle_channel_name->text()) {
			qlb_channels->removeItem(i);
			break;
		}
	}
	
	qlb_channels->sort();
}

void QTVConfigImpl::changeChannel(const QString &channel_name) {
	pair<QString*, unsigned long> *e;
	for(e=channels->first(); e!=0; e=channels->next()) {
		if(*(e->first)==channel_name) {
			current_channel=channel_name;
      if(v4l->hasTuner()) {
        v4l->setTunerFrequency(e->second);
      }
			break;
		}
	}
}
