#include "dxpcconf.h"
#include <string.h>
#include <X11/X.h>
#include <X11/Xatom.h>
#ifndef __CYGWIN32__
#include <X11/Xproto.h>
#else
#include "Xproto-cygwin.h"
#endif
#include "ClientChannel.H"
#include "EncodeBuffer.H"
#include "DecodeBuffer.H"
#include "util.H"
#include "assert.h"

#include "Compresser.H"
#include "Decompresser.H"

Decompresser::Decompresser(int compressionLevel)
{
    decompressionFnc = Compresser::getDecompresser(compressionLevel);
}

Decompresser::~Decompresser()
{
}

void 
Decompresser::decompressBuffer(CompressionType compressionType,
			             unsigned char *outBuffer, 
				     DecodeBuffer &decodeBuffer)
{
    lzo_uint compressedSize, size;
    unsigned value;

    if (!decompressionFnc || compressionType != LZO_COMPRESSION)
    {
	return;
    }

    decodeBuffer.decodeValue(value, sizeof(lzo_uint) * 8);
    compressedSize = (lzo_uint)value;
    decodeBuffer.decodeValue(value, sizeof(lzo_uint) * 8);
    size = (lzo_uint)value;

    decompressionFnc(decodeBuffer.decodeRawMem(compressedSize), 
		     compressedSize, 
		     outBuffer, &size, NULL);
}
