% Build file for Dynare MEX Librairies for Octave

% Copyright (C) 2008 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

COMPILE_OPTIONS = '-DNO_BLAS_H -DNO_LAPACK_H -DOCTAVE';

% Comment next line to suppress compilation debugging info
COMPILE_OPTIONS = [ COMPILE_OPTIONS ' -v' ];

COMPILE_COMMAND = [ 'mex ' COMPILE_OPTIONS ];

disp('Compiling mjdgges...')
eval([ COMPILE_COMMAND ' mjdgges/mjdgges.c -o ../octave/mjdgges.mex']);
disp('Compiling sparse_hessian_times_B_kronecker_C...')
eval([ COMPILE_COMMAND ' kronecker/sparse_hessian_times_B_kronecker_C.cc -o ../octave/sparse_hessian_times_B_kronecker_C.mex']);
disp('Compiling A_times_B_kronecker_C...')
eval([ COMPILE_COMMAND ' kronecker/A_times_B_kronecker_C.cc -o ../octave/A_times_B_kronecker_C.mex']);
disp('Compiling gensylv...')
eval([ COMPILE_COMMAND ' -DMATLAB -Igensylv/cc ' ...
       'gensylv/matlab/gensylv.cpp ' ...
       'gensylv/cc/BlockDiagonal.cpp ' ... 
       'gensylv/cc/GeneralMatrix.cpp ' ...
       'gensylv/cc/GeneralSylvester.cpp ' ...
       'gensylv/cc/IterativeSylvester.cpp ' ...
       'gensylv/cc/KronUtils.cpp ' ...
       'gensylv/cc/KronVector.cpp ' ...
       'gensylv/cc/QuasiTriangular.cpp ' ...
       'gensylv/cc/QuasiTriangularZero.cpp ' ...
       'gensylv/cc/SchurDecomp.cpp ' ...
       'gensylv/cc/SchurDecompEig.cpp ' ...
       'gensylv/cc/SimilarityDecomp.cpp ' ...
       'gensylv/cc/SylvException.cpp ' ...
       'gensylv/cc/SylvMatrix.cpp ' ...
       'gensylv/cc/SylvMemory.cpp ' ...
       'gensylv/cc/SylvParams.cpp ' ...
       'gensylv/cc/TriangularSylvester.cpp ' ...
       'gensylv/cc/Vector.cpp ' ...
       '-o ../octave/gensylv.mex']);
disp('Compiling simulate...')
eval([ COMPILE_COMMAND ' -Isimulate -I../../preprocessor/include simulate/simulate.cc simulate/Interpreter.cc simulate/Mem_Mngr.cc simulate/SparseMatrix.cc -o ../octave/simulate.mex']);
