function mode_check(x,fval,hessian,gend,data,lb,ub)

% function mode_check(x,fval,hessian,gend,data,lb,ub)
% Checks the maximum likelihood mode 
% 
% INPUTS
%    x:       mode
%    fval:    value at the maximum likelihood mode
%    hessian: matrix of second order partial derivatives
%    gend:    scalar specifying the number of observations
%    data:    matrix of data
%    lb:      lower bound
%    ub:      upper bound
%
% OUTPUTS
%    none
%        
% SPECIAL REQUIREMENTS
%    none

% Copyright (C) 2003-2008 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

global bayestopt_ M_ options_

TeX = options_.TeX;
[s_min,k] = min(diag(hessian))
  
disp('\nMODE CHECK\n')
disp(sprintf('Fval obtained by fmincon: %f', fval))
disp(bayestopt_.name)
cname = bayestopt_.name{k};
disp(sprintf('Most negative variance %f for parameter %d (%s = %f)',s_min,k,cname,x(k)))

[nbplt,nr,nc,lr,lc,nstar] = pltorg(length(x));

if TeX
    fidTeX = fopen([M_.fname '_CheckPlots.TeX'],'w');
    fprintf(fidTeX,'%% TeX eps-loader file generated by mode_check.m (Dynare).\n');
    fprintf(fidTeX,['%% ' datestr(now,0) '\n']);
    fprintf(fidTeX,' \n');
end


if nbplt == 1
    if TeX
        NAMES = [];
        TeXNAMES = [];
    end    
    hh = figure('Name','Check plots');
    for k=1:length(x)
        subplot(nr,nc,k)
        [name,texname] = get_the_name(k,TeX);
        if TeX
            NAMES = strvcat(NAMES,name);
            TeXNAMES = strvcat(TeXNAMES,texname);
        end    
        xx = x;
        l1 = max(lb(k),0.8*x(k)); % kk -> k
        l2 = min(ub(k),1.2*x(k)); % kk -> k
        z = [l1:(l2-l1)/20:l2];
        y = zeros(length(z),1);
        for i=1:length(z)
            xx(k) = z(i); % kk -> k
            if isempty(strmatch('dsge_prior_weight',M_.param_names))
                y(i) = DsgeLikelihood(xx,gend,data);
            else
                y(i) = DsgeVarLikelihood(xx,gend);
            end
        end
        plot(z,y)
        hold on
        yl=get(gca,'ylim');
        plot([x(k) x(k)],yl,'c','LineWidth', 1);% kk -> k
        title(name,'interpreter','none');
        hold off
        drawnow
    end
    eval(['print -depsc2 ' M_.fname '_CheckPlots' int2str(1) '.eps' ]);
    if ~exist('OCTAVE_VERSION')
        eval(['print -dpdf ' M_.fname '_CheckPlots' int2str(1)]);
        saveas(hh,[M_.fname '_CheckPlots' int2str(1) '.fig']);
    end
    if options_.nograph, close(hh), end  
    % TeX eps loader file
    if TeX
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:length(x)
            fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',M_.fname,int2str(1));
        fprintf(fidTeX,'\\caption{Priors.}');
        fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(1));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,'\n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
    end    
else
    for plt = 1:nbplt-1
        if TeX
            NAMES = [];
            TeXNAMES = [];
        end    
        hh = figure('Name','Check plots');
        for k=1:nstar
            subplot(nr,nc,k)
            kk = (plt-1)*nstar+k;
            [name,texname] = get_the_name(kk,TeX);
            if TeX
                NAMES = strvcat(NAMES,name);
                TeXNAMES = strvcat(TeXNAMES,texname);
            end    
            xx = x;
            l1 = max(lb(kk),0.8*x(kk));
            l2 = min(ub(kk),1.2*x(kk));
            z = [l1:(l2-l1)/20:l2];
            y = zeros(length(z),1);
            for i=1:length(z)
                xx(kk) = z(i);
                if isempty(strmatch('dsge_prior_weight',M_.param_names))
                    y(i) = DsgeLikelihood(xx,gend,data);
                else
                    y(i) = DsgeVarLikelihood(xx,gend);
                end                
            end
            plot(z,y);
            hold on
            yl=get(gca,'ylim');
            plot( [x(kk) x(kk)], yl, 'c', 'LineWidth', 1)
            title(name,'interpreter','none')
            hold off
            drawnow
        end    
        eval(['print -depsc2 ' M_.fname '_CheckPlots' int2str(plt) '.eps']);
        if ~exist('OCTAVE_VERSION')
            eval(['print -dpdf ' M_.fname '_CheckPlots' int2str(plt)]);
            saveas(hh,[M_.fname '_CheckPlots' int2str(plt) '.fig']);
        end
        if options_.nograph, close(hh), end
        if TeX
            % TeX eps loader file    
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            for jj = 1:nstar
                fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
            end    
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',M_.fname,int2str(plt));
            fprintf(fidTeX,'\\caption{Check plots.}');
            fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(plt));
            fprintf(fidTeX,'\\end{figure}\n');
            fprintf(fidTeX,' \n');
        end
    end
    hh = figure('Name','Check plots');
    k = 1;
    if TeX
        NAMES = [];
        TeXNAMES = [];
    end
    while (nbplt-1)*nstar+k <= length(x)
        kk = (nbplt-1)*nstar+k;
        [name,texname] = get_the_name(kk,TeX);
        if TeX
            NAMES = strvcat(NAMES,name);
            TeXNAMES = strvcat(TeXNAMES,texname);
        end    
        if lr ~= 0
            subplot(lr,lc,k)
        else
            subplot(nr,nc,k)
        end    
        xx = x;
        l1 = max(lb(kk),0.8*x(kk));
        l2 = min(ub(kk),1.2*x(kk));
        z = [l1:(l2-l1)/20:l2];
        y = zeros(length(z),1);
        for i=1:length(z)
            xx(kk) = z(i);
            if isempty(strmatch('dsge_prior_weight',M_.param_names))
                y(i) = DsgeLikelihood(xx,gend,data);
            else
                y(i) = DsgeVarLikelihood(xx,gend);
            end                
        end
        plot(z,y)
        hold on
        yl=get(gca,'ylim');
        plot( [x(kk) x(kk)], yl, 'c', 'LineWidth', 1)
        title(name,'interpreter','none')
        hold off
        k = k + 1;
        drawnow
    end
    eval(['print -depsc2 ' M_.fname '_CheckPlots' int2str(nbplt) '.eps']);
    if ~exist('OCTAVE_VERSION')
        eval(['print -dpdf ' M_.fname '_CheckPlots' int2str(nbplt)]);
        saveas(hh,[M_.fname '_CheckPlots' int2str(nbplt) '.fig']);
    end
    if options_.nograph, close(hh), end
    if TeX
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:lr*lc
            fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',M_.fname,int2str(nbplt));
        fprintf(fidTeX,'\\caption{Check plots.}');
        fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(nbplt));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,' \n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
    end
end

% SA 07-31-2004		* New default : no more than nine plots per figure.
%					* Figures are automatically saved in eps, pdf and fig formats.
%					* Figures are automatically closed (this should be an option).
%					* Creation of a TeX-loader file for the postcript file. 