function e = euler_equation_error(y0,x,innovations,M,options,oo,pfm,nodes,weights)

% Copyright (C) 2016-2017 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

dynamic_model = str2func([M.fname '.dynamic']);
ep = options.ep;
[y1, info_convergence, endogenousvariablespaths] = extended_path_core(ep.periods, ...
                                                  M.endo_nbr, M.exo_nbr, ...
                                                  innovations.positive_var_indx, ...
                                                  x, ep.init, y0, oo.steady_state, ...
                                                  0, ep.use_bytecode, ...
                                                  ep.stochastic.order, M, ...
                                                  pfm, ep.stochastic.algo, ...
                                                  ep.solve_algo, ...
                                                  ep.stack_solve_algo, ...
                                                  options.lmmcp, options, oo, ...
                                                  []);
i_pred = find(M.lead_lag_incidence(1,:));
i_fwrd = find(M.lead_lag_incidence(3,:));
x1 = [x(2:end,:); zeros(1,M.exo_nbr)];
for i=1:length(nodes)
    x2 = x1;
    x2(2,:) = x2(2,:) + nodes(i,:);
    [y2, info_convergence, endogenousvariablespaths] = ...
        extended_path_core(ep.periods, M.endo_nbr, M.exo_nbr, ...
                           innovations.positive_var_indx, x2, ep.init, ...
                           y1, oo.steady_state, 0, ep.use_bytecode, ...
                           ep.stochastic.order, M, pfm, ep.stochastic.algo, ...
                           ep.solve_algo, ep.stack_solve_algo, options.lmmcp, ...
                           options, oo, []);

    z = [y0(i_pred); y1; y2(i_fwrd)];
    res(:,i) = dynamic_model(z,x,M.params,oo.steady_state,2);
end
e = res*weights;