/*************************************************************************************/
/*										     */
/* Util.h									     */
/*										     */
/* Structures and definitions specific to initializing the EzUSB (8051) chip.	     */
/*										     */
/* This file is part of the "ADI USB ADSL Driver for Linux".			     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it 	     */
/* and/or modify it under the terms of the GNU General Public License as 	     */
/* published by the Free Software Foundation; either version 2 of the License,       */
/* or (at your option) any later version.					     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be 	     */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	     */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		     */
/* GNU General Public License for more details.					     */
/*										     */
/* You should have received a copy of the GNU General Public License		     */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software    */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	     */
/*************************************************************************************/

#ifndef __ADIUTIL_H__
#define __ADIUTIL_H__

/*
    Firmware record structure
 */
#define MAX_FIRMWARE_RECORD_LENGTH 16
typedef struct _FIRMWARE_RECORD
{
    UInt8  Type;
    UInt8  Length;
    UInt16 Address;
    UInt8  Data[MAX_FIRMWARE_RECORD_LENGTH];
} __attribute__((packed)) FIRMWARE_RECORD, *PFIRMWARE_RECORD;

/* int loadUsbFirmware(Hardware *pHw, FIRMWARE_RECORD *aRecords, UInt32 BufSize); */
int loadUsbFirmware ( Hardware *pHw, UInt32 pid );
void WriteDspMsg(Hardware *pHw, UInt16 Addr, UInt16 *pData);
int AdiCustomWrite(Hardware *pHw, UInt32 Cmd, UInt32 Index, UInt32 Count, UInt8 *pData);
int AdiCustomWriteIm(Hardware *pHw, UInt32 Cmd, UInt32 Index, UInt32 Count, UInt8 *pData);
void GetMacAddress(Hardware *pHw);

int alloc_queued_urb_ctrl ( Hardware *pHw, unsigned int count );
void free_queued_urb_ctrl ( struct list_head *q );
void ctrl_urb_q_watcher ( unsigned long ptr );
void unlink_ipg_ctrl_urb ( Hardware *pHw );
void ctrl_urb_retry_send ( unsigned long ptr );


#endif
