/********************************************************************************/
/* $Id: Zaps.c,v 1.4 2003/06/03 22:41:19 sleeper Exp $ 			*/
/*										*/
/* Zaps.c									*/
/*										*/
/* IOLog-based debugging output facility					*/
/*										*/
/* To control which modules you see information about, set ModuleMask to a      */
/* sum of the DEBUG_* module defs you want. For example, if you want to see     */
/* details of the SAR and MPOA modules, set ModuleMask = DEBUG_MPOA+DEBUG_SAR.  */
/* To control the level of information you see, set LevelMask to a sum of the   */
/* DEBUG_* level defs you want. For example, to see everytime a function is     */
/* entered, and any errors that occur, set LevelMask = DEBUG_ENTRY+DEBUG_ERRORS.*/
/********************************************************************************/

#include "Adiutil.h"

/********************************************************************************/
/* Some global data ...							        */
/********************************************************************************/

UInt32 ModuleMask = 
/*
                    DEBUG_SAR +
                    DEBUG_UNI +
                    DEBUG_MPOA +
                    DEBUG_INIT +
                    DEBUG_FIRMWARE +
                    DEBUG_PIPES +
                    DEBUG_BOOT +
                    DEBUG_ENET +
                    DEBUG_READ + 
                    DEBUG_SM +
                    DEBUG_CRC + 
                    DEBUG_WRITE +
                    DEBUG_MSG +
                    DEBUG_INTS +
                    DEBUG_UTILS +
                    DEBUG_IDMA +
                    DEBUG_POWER +
                    DEBUG_MISC +
                    DEBUG_START +
                    DEBUG_DSP +
                    DEBUG_MEMORY +
                    DEBUG_URB +
*/
                    DEBUG_SM +
                    0;

/* UInt32 LevelMask  = DEBUG_ALL; */
UInt32 LevelMask = DEBUG_ATTN | DEBUG_ERROR | DEBUG_INFO | DEBUG_DATA;


/********************************************************************************/
/* DoZap									*/
/*										*/
/* Checks the current module and level masks to see if this debug output	*/
/* should be shown to the user or not.						*/
/********************************************************************************/
Boolean DoZap( UInt32 myModule, UInt32 myLevel )
{
    if ((myLevel & DEBUG_ERRORS) || (myLevel & DEBUG_ATTN))
       return TRUE;

    if ((myModule & ModuleMask) && (myLevel & LevelMask))
       return TRUE;
    else
       return FALSE;
}

/*********************************************************************************************
$Log: Zaps.c,v $
Revision 1.4  2003/06/03 22:41:19  sleeper
*** empty log message ***

Revision 1.3  2003/03/31 22:04:06  sleeper
Change default debug mask

Revision 1.2  2003/03/21 00:22:41  sleeper
Msg Initialization modifs from 2.0.1

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.90  2002/05/27 22:59:33  Anoosh Naderi
Clean up the code

Revision 1.8  2002/01/16 22:59:33  steve.urquhart
Moved portion of DspFoodProcessor and invocation of BootTheModem to
adi_user ioctl handler.  Removed LoadAndPrepareDsp.  Cleaned up the ioctl
interface.  Decreased initial DSP vmalloc to less than .5MB.

Revision 1.6  2001/12/28 19:40:10  chris.edgington
Default to no modules enabled for debug.

Revision 1.5  2001/12/22 19:57:18  chris.edgington
Enabled debugging of all known modules.

Revision 1.4  2001/12/21 23:45:11  chris.edgington
Added DEBUG_URB as a valid module.

Revision 1.3  2001/12/20 22:33:41  chris.edgington
Added DEBUG_MEMORY as a valid module.

Revision 1.2  2001/12/17 22:17:34  chris.edgington
Enabled DEBUG_INIT module debugging.

Revision 1.1.1.1  2001/12/14 21:27:20  chris.edgington
Initial import

---------------------------------------------------------------------------
 Log entries from MacOS9 project
---------------------------------------------------------------------------

Revision 1.12  2001/11/12 14:23:25  chris.edgington
Added some comments and did some simple reformatting in preparation for code review.

Revision 1.11  2001/10/24 15:02:51  ilko.dossev
All module-specific debug flags turned off - to be switched on need-to basis, only locally.

Revision 1.10  2001/10/18 22:41:34  martyn.deobald
Added DEBUG_POWER to module list

Revision 1.9  2001/10/12 17:57:18  ilko.dossev
All non-error ZAPs commented out, including INIT

Revision 1.8  2001/10/11 19:50:35  chris.edgington
Added automatic debug output for DEBUG_ERRORS and DEBUG_ATTN, regardless of module setting.

Revision 1.7  2001/10/05 18:06:37  ilko.dossev
"LazyCommentOut" construction set for ModuleMask initialization.

Revision 1.6  2001/10/05 16:10:29  chris.edgington
Added DEBUG_CRC as a valid module.
Added DEBUG_DATA as a valid debug level.

Revision 1.5  2001/10/04 15:55:05  chris.edgington
Added functions for getting and setting the ZAP levels.
Added DEBUG_INTS and DEBUG_ENET as valid modules.

Revision 1.4  2001/10/03 21:48:34  chris.edgington
Modified default module ZAP level to fix boot timing problem.

Revision 1.3  2001/09/24 18:06:48  chris.edgington
Removed multiple includes, added single include of Adiutil.h.
Changed default debug output to DEBUG_ALL.

Revision 1.2  2001/09/23 21:55:53  chris.edgington
Added some documentation on how to use Zaps facility. Made DoZaps check proper masks for determining whether or not to output the debug string.

Revision 1.1  2001/09/20 21:13:25  chris.edgington
First version.
*************************************************************************************************/
