/*
    Copyright (C) C. Casteyde, 2002.
    This file is in the public domain.
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <netinet/in.h>

#include "HexRecord.h"
#include "Firmware8051.h"

#define FIRMWAREFILE "firmware.bin"

int main(void)
{
    int iResult = EXIT_FAILURE;
    FILE *f = fopen(FIRMWAREFILE, "w");
    if (NULL != f)
    {
	int i=0;
	do
	{
	    /* We reorganize firmware data to keep firmware file naturally aligned: */
	    size_t written;
	    uint16_t ui16Address;
	    written = fwrite(&Firmware8051_Eagle[i].ui8Type, sizeof(uint8_t), 1, f);
	    if (1 != written) break;
	    written = fwrite(&Firmware8051_Eagle[i].ui8Length, sizeof(uint8_t), 1, f);
	    if (1 != written) break;
	    /* We must ensure the file is endianess independant: */
	    ui16Address = htons(Firmware8051_Eagle[i].ui16Address);
	    written = fwrite(&ui16Address, sizeof(uint16_t), 1, f);
	    if (1 != written) break;
	    written = fwrite(&Firmware8051_Eagle[i].aData, sizeof(uint8_t),
		MAX_RECORD_LENGTH, f);
	    if (MAX_RECORD_LENGTH != written) break;
	    /* Exit if the last record was written: */
	    if (0 != Firmware8051_Eagle[i].ui8Type)
		break;
	    /* Go to the next record: */
	    ++i;
	} while (1);
	fclose(f);
	if (0 != Firmware8051_Eagle[i].ui8Type)
	    iResult = EXIT_SUCCESS;
	else
	    fprintf(stderr,
		"Unable to write all firmware records to file \""FIRMWAREFILE"\"!\n");
    }
    else
    {
	fprintf(stderr, "Unable to create \""FIRMWAREFILE"\" file!\n");
    }
    return iResult;
}
