# $Header: /home/cvsroot/driver/eagle/scripts/distrib/gentoo/eagle/eagle-1.0.4_pre5.ebuild,v 1.4 2003/06/12 23:57:13 sleeper Exp $

DESCRIPTION="GPL Driver for Eagle Chipset powered ADSL modem under *nix"
SRC_URI="http://sl33p3r.free.fr/eagle/${P}.tar.gz"
HOMEPAGE="http://eagle-usb.fr.st/"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="x86 ~ppc"
IUSE="routedip"

DEPEND=""
RDEPEND=">=net-dialup/ppp-2.4.1
        routedip? ( net-misc/dhcpcd )"

src_compile() {
	local myconf
	cd ${WORKDIR}/eagle-1.0.4-pre3.2
	emake clean || die "make clean failed"

	emake || die "make failed"

}

src_install () {

	# Install utils
	into /usr ; dosbin driver/user/adictrl scripts/adsl/startadsl \
    scripts/adsl/stopadsl  driver/user/showstat

	# Install module
	insinto /lib/modules/${KV}/kernel/drivers/usb
	doins driver/adiusbadsl.o

	# 

	insinto /etc/analog/
	newins driver/firmware/DSPcode.bin DSPcode.bin
	newins driver/firmware/firmware.bin firmware.bin
	newins driver/user/sagemf800.conf adiusbadsl.conf

	dodoc lisezmoi.txt Changelog readme.txt TODO VERSION BUGS
	rm -r ${D}/etc/init.d/eagle-adsl
	exeinto /etc/init.d ; newexe ${FILESDIR}/eagle-adsl eagle-adsl
	insinto /etc/conf.d ; newins ${FILESDIR}/eagle-adsl.confd eagle-adsl
	if [ "`use routedip`" ] ;
	then
		echo "ROUTEDIP=1" >> ${D}/etc/conf.d/eagle-adsl
		# We must also change encapsulation, VPI/VCI
		sed -i -e 's/Encapsulation *= *[0-9]\+/Encapsulation=00000004/' ${D}/etc/analog/adiusbadsl.conf
		sed -i -e 's/VCI *= *[0-9]\+/VCI=00000024/' ${D}/etc/analog/adiusbadsl.con
	else
		echo "ROUTEDIP=0" >> ${D}/etc/conf.d/eagle-adsl
		insopts -m 600 ; insinto /etc/ppp/peers ; doins ${FILESDIR}/dsl.peer
    fi
}


pkg_postinst() {

	if [ "${ROOT}" = "/" ]
    then
        # Update module dependency
		[ -x /usr/sbin/update-modules ] && /usr/sbin/update-modules
	fi

	echo ""
	ewarn "Make sure you have kernel support for USB, HDCL and PPP"
	echo ""
	ewarn "Edit /etc/ppp/peers/dsl.peer to insert your username as well as"
	ewarn " /etc/ppp/chap-secrets and /etc/ppp/pap-secrets and then "
	ewarn "bring up your adsl line using the /etc/init.d/eagle-adsl script"
	echo ""
	einfo "If you are not using devfs, to load the module automatically at"
	einfo "boot ti,e, you need to add \"adiusbadsl\" to your /etc/modules.autoload."
	echo ""
	einfo "More info in the documentation in /usr/share/doc/${P}"
	echo ""
}