# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from lib_pulseaudio import *
import gobject
import ctypes
import logging
from Client import Client
from SinkInput import SinkInput
from Sink import Sink
from SourceOutput import SourceOutput
from Source import Source
PA_VOLUME_CONVERSION_FACTOR = 655.36

log = logging.getLogger('PulseAudioConnection')
log.setLevel(logging.WARNING)

# A null method that can be given to pulse methods
def null_cb(a=None, b=None, c=None, d=None):
    #print "NULL CB"
    return

class PulseAudioConnection():

    def __init__(self, Name="Simple Pulse Audio Connection"):
        
        self.Name = Name

        self.sinks = {}
        self.monitor_sinks = []
        self.module_stream_restore_argument = ""

    def connect(self):

        self.__mainloop = pa_threaded_mainloop_new()
        self.__mainloop_api = pa_threaded_mainloop_get_api(self.__mainloop)

        self._context = pa_context_new(self.__mainloop_api, self.Name )   

        self._context_notify_cb = pa_context_notify_cb_t(self.context_notify_cb) 
        pa_context_set_state_callback(self._context, self._context_notify_cb, None)   

        pa_context_connect(self._context, None, 0, None);
        pa_threaded_mainloop_start(self.__mainloop)

    def disconnect(self):
        pa_context_disconnect(self._context)

    # pulseaudio connection status    
    def context_notify_cb(self, context, userdata):
        
        try:
            ctc = pa_context_get_state(context)
            if ctc == PA_CONTEXT_READY:
                log.debug("connection ready")

                self._null_cb = pa_context_success_cb_t(null_cb)
                self._pa_context_success_cb = pa_context_success_cb_t(self.__pa_context_success_cb)
                self._pa_stream_request_cb = pa_stream_request_cb_t(self.__pa_stream_request_cb)
                self._pa_stream_notify_cb = pa_stream_notify_cb_t(self.__pa_stream_request_cb)
                self._pa_sink_info_cb = pa_sink_info_cb_t(self.__pa_sink_info_cb)
                self._pa_context_subscribe_cb = pa_context_subscribe_cb_t(self.__pa_context_subscribe_cb)
                self._pa_source_info_cb = pa_source_info_cb_t(self.__pa_source_info_cb)
                self._pa_source_output_info_cb = pa_source_output_info_cb_t(self.__pa_source_output_info_cb)
                self._pa_sink_input_info_list_cb = pa_sink_input_info_cb_t(self.__pa_sink_input_info_cb)
                self._pa_client_info_list_cb = pa_client_info_cb_t(self.__pa_client_info_cb)
                self._pa_module_info_cb = pa_module_info_cb_t(self.__pa_module_info_cb)
                self._pa_context_index_cb = pa_context_index_cb_t(self.__pa_context_index_cb) 

                o = pa_context_get_module_info_list(self._context, self._pa_module_info_cb, True)
                pa_operation_unref(o)

                o = pa_context_get_source_info_list(self._context, self._pa_source_info_cb, True)
                pa_operation_unref(o)

                o = pa_context_get_sink_info_list(self._context, self._pa_sink_info_cb, True)
                pa_operation_unref(o)

                o = pa_context_get_client_info_list(self._context, self._pa_client_info_list_cb, None)
                pa_operation_unref(o)
                
                o = pa_context_get_source_output_info_list(self._context, self._pa_source_output_info_cb, None)
                pa_operation_unref(o)

                o = pa_context_get_sink_input_info_list(self._context, self._pa_sink_input_info_list_cb, True)
                pa_operation_unref(o)

                pa_context_set_subscribe_callback(self._context, self._pa_context_subscribe_cb, None);
                o = pa_context_subscribe(self._context, (pa_subscription_mask_t)
                                               (PA_SUBSCRIPTION_MASK_SINK |
                                                PA_SUBSCRIPTION_MASK_SOURCE |
                                                PA_SUBSCRIPTION_MASK_SINK_INPUT |
                                                PA_SUBSCRIPTION_MASK_SOURCE_OUTPUT |
                                                PA_SUBSCRIPTION_MASK_CLIENT |
                                                PA_SUBSCRIPTION_MASK_SERVER), self._null_cb, None)  

                pa_operation_unref(o)     
                gobject.idle_add(self.pa_status_ready)        

            if ctc == PA_CONTEXT_FAILED :
                log.debug("connection failed")
                pa_threaded_mainloop_signal(self.__mainloop, 0)
                
            if ctc == PA_CONTEXT_TERMINATED:
                log.debug("connection terminated")
                pa_threaded_mainloop_signal(self.__mainloop, 0)

        except Exception, text:
            log.exception("context_notify_cb %s" % text)

    def __pa_context_index_cb(self, context, index, user_data):
        log.debug("__pa_context_index_cb")
        gobject.idle_add(self.pa_context_index_cb,  index, user_data)
        return

    def __pa_module_info_cb(self, context, struct, eol, user_data):
        
        if struct:
            log.debug("__pa_module_info_cb : %s" % struct.contents.name)
            gobject.idle_add(self.pa_module_info_cb, struct.contents, eol, user_data)

    def __pa_source_info_cb(self, context, struct, eol, user_data):
        if struct:
            source = Source(self, struct.contents)
            log.debug("__pa_source_info_cb : %s" % struct.contents.name)
            gobject.idle_add(self.pa_source_info_cb, source, eol, user_data)

    def __pa_source_output_info_cb(self, context, struct, c_int, user_data):
            if struct:
                source_output = SourceOutput(self, struct.contents)
                log.debug("__pa_source_output_info_cb : %s" % struct.contents.name)
                gobject.idle_add(self.pa_source_output_info_cb, source_output, user_data)

    def __pa_context_success_cb(self, context, c_int, user_data):
        log.debug("__pa_source_output_info_cb")
        gobject.idle_add(self.pa_context_success_cb, c_int, user_data)

    def __pa_stream_request_cb(self, stream, length, user_data):
        data = self.pa_stream_peek(stream, length)
        v = data[length / 4 -1] * 100
        if (v < 0):
            v = 0
        if (v > 100):
            v = 100
        self.pa_stream_drop(stream)

        #log.debug("__pa_stream_request_cb")
        gobject.idle_add(self.pa_stream_request_cb, v, user_data)

    def __pa_context_subscribe_cb(self, context, event_type, index, user_data):

        try:
            et = event_type & PA_SUBSCRIPTION_EVENT_FACILITY_MASK

            if et == PA_SUBSCRIPTION_EVENT_CLIENT:
                
                if event_type & PA_SUBSCRIPTION_EVENT_TYPE_MASK == PA_SUBSCRIPTION_EVENT_REMOVE:
                    log.debug("PA_SUBSCRIPTION_EVENT_CLIENT | PA_SUBSCRIPTION_EVENT_REMOVE : %d" % index)
                    gobject.idle_add(self.pa_client_remove_cb, int(index))
                else:
                    o = pa_context_get_client_info(self._context, index, self._pa_client_info_list_cb, None)
                    pa_operation_unref(o)

            if et == PA_SUBSCRIPTION_EVENT_SINK_INPUT:
                if event_type & PA_SUBSCRIPTION_EVENT_TYPE_MASK == PA_SUBSCRIPTION_EVENT_REMOVE:
                    log.debug("PA_SUBSCRIPTION_EVENT_SINK_INPUT | PA_SUBSCRIPTION_EVENT_REMOVE : %d" % index)
                    gobject.idle_add(self.pa_sink_input_remove_cb, int(index))
                else:
                    o = pa_context_get_sink_input_info(self._context, int(index), self._pa_sink_input_info_list_cb, True)
                    pa_operation_unref(o)
                    
            if et == PA_SUBSCRIPTION_EVENT_SINK:
                if event_type & PA_SUBSCRIPTION_EVENT_TYPE_MASK == PA_SUBSCRIPTION_EVENT_REMOVE:
                    log.debug("PA_SUBSCRIPTION_EVENT_SINK | PA_SUBSCRIPTION_EVENT_REMOVE : %d" % index)
                    gobject.idle_add(self.pa_sink_remove_cb, int(index))
                else:
                    o = pa_context_get_sink_info_by_index(self._context, int(index), self._pa_sink_info_cb, False)
                    pa_operation_unref(o)

            if et == PA_SUBSCRIPTION_EVENT_SOURCE:
                if event_type & PA_SUBSCRIPTION_EVENT_TYPE_MASK == PA_SUBSCRIPTION_EVENT_REMOVE:
                    log.debug("PA_SUBSCRIPTION_EVENT_SOURCE | PA_SUBSCRIPTION_EVENT_REMOVE : %d" % index)
                    gobject.idle_add(self.pa_source_remove_cb, int(index))
                else:
                    o = pa_context_get_source_info_by_index(self._context, int(index), self._pa_source_info_cb, False)
                    pa_operation_unref(o)


        except Exception, text:
            log.exception("PA ERROR pa_context_subscribe_cb %s" % text)
    
    def __pa_client_info_cb(self, context, struct, c_int, user_data):
        if struct:
            client = Client(self, struct.contents)
            log.debug("__pa_client_info_cb : %s" % struct.contents.name)
            gobject.idle_add(self.pa_client_info_cb, client, user_data)
   
    def __pa_sink_input_info_cb(self, context, struct, index, user_data):
        if struct:
            sink_input = SinkInput(self, struct.contents)
            log.debug("__pa_sink_input_info_cb : %s" % struct.contents.name)
            gobject.idle_add( self.pa_sink_input_info_cb, sink_input, user_data)

    def __pa_sink_info_cb(self, context, struct, index, user_data):
        if struct:
            sink = Sink(self, struct.contents)
            log.debug("__pa_sink_info_cb : %s" % struct.contents.name)
            gobject.idle_add( self.pa_sink_info_cb, sink, user_data)

    # EVENTS
    def pa_client_info_cb(self, client, user_data):
        return
    def pa_client_remove_cb(self, index):
        return

    def pa_sink_input_info_cb(self, sink_input, user_data):
        return
    def pa_sink_input_remove_cb(self, index):
        return

    def pa_sink_info_cb(self, sink, user_data):
        return
    def pa_sink_remove_cb(self, index):
        return

    def pa_source_info_cb(self, contents, eol, user_data):
        return
    def pa_source_remove_cb(self, index):
        return

    def pa_module_info_cb(self, contents, eol, user_data):
        return
    def pa_source_output_info_cb(self, contents, index, user_data):
        return
    def pa_stream_request_cb(self, meter, index):
        return
    def pa_context_success_cb(self, c_int, user_data):
        return
    def pa_context_index_cb(self, index, user_data):
        return

    def pa_status_ready(self):
        return


    def pa_buffer_attr(self):
        return pa_buffer_attr()
    def pa_sample_spec(self):
        return pa_sample_spec()
    def pa_stream_new(self, name, sample_spec):
        return pa_stream_new(self._context, name, sample_spec, None)
    def pa_stream_set_monitor_stream(self, pa_stream, index):
        return pa_stream_set_monitor_stream(pa_stream, index)
    def pa_stream_set_read_callback(self, pa_stream, index):
        return pa_stream_set_read_callback(pa_stream, self._pa_stream_request_cb, index)
    def pa_stream_set_suspended_callback(self, pa_stream):
        return pa_stream_set_suspended_callback(pa_stream, self._pa_stream_notify_cb, "DOOM")
    def pa_stream_connect_record(self, pa_stream, monitor_index, attr, size):
        return pa_stream_connect_record(pa_stream, monitor_index, attr, size) 
    def pa_stream_peek(self, stream, length):
        data = POINTER(c_float)()
        pa_stream_peek(stream, data, ctypes.c_ulong(length))
        return data
    def pa_stream_drop(self, stream):
        pa_stream_drop(stream)


    # METHODS
    def pa_context_get_sink_info_list(self):
        o = pa_context_get_sink_info_list(self._context, self._pa_sink_info_cb, True)
        pa_operation_unref(o)

    def pa_context_get_source_output_info_list(self):
        o = pa_context_get_source_output_info_list(self._context, self._pa_source_output_info_cb, True)
        pa_operation_unref(o)

    def pa_context_get_source_info_list(self):
        o = pa_context_get_source_info_list(self._context, self._pa_source_info_cb, True)
        pa_operation_unref(o)

    def pa_proplist_gets(self, proplist, name):
        return pa_proplist_gets(proplist, name)

    def convert_simple_volume_to_pa_volume(self, volume):
        vol = pa_cvolume()
        vol.channels = len(volume)
        v = pa_volume_t * 32
        vol.values = v()
        for i in range(0, len(volume)):
            if i == 32: return vol
            channel_volume = volume[i]
            if channel_volume < 0: channel_volume = 0
            if channel_volume > 100: channel_volume = 100
            vol.values[i] = int(channel_volume * PA_VOLUME_CONVERSION_FACTOR)
        return vol

    def convert_pa_volume_to_simple_volume(self, volume):
        vol = []
        for i in range(0, volume.channels):
            vol.append( int(volume.values[i] / PA_VOLUME_CONVERSION_FACTOR) )
        return vol

    def pa_context_move_sink_input_by_index(self, sink_input_index, sink_index):
        pa_context_move_sink_input_by_index(self._context, sink_input_index, sink_index, self._pa_context_success_cb, None)

    def pa_context_move_sink_input_by_name(self, sink_index, output_name):
        pa_context_move_sink_input_by_name(self._context, sink_index, output_name, self._pa_context_success_cb, None)

    def pa_context_set_sink_volume_by_name(self, sink_name, volume):       
        vol = self.convert_simple_volume_to_pa_volume(volume)
        o = pa_context_set_sink_volume_by_name(self._context, sink_name, vol, self._null_cb, None)
        pa_operation_unref(o)

    def pa_context_set_sink_input_volume(self, index, volume):
        log.debug("pa_context_set_sink_input_volume : %s" % index)
        vol = self.convert_simple_volume_to_pa_volume(volume)
        o = pa_context_set_sink_input_volume(self._context, index, vol, self._null_cb, None) # NOTE: dont pass in any thing here causes a seg fault
        pa_operation_unref(o)

    def pa_context_get_sink_info_by_name(self, sink_name):
        o = pa_context_get_sink_info_by_name(self._context, sink_name, self._pa_sink_info_cb, False)
        pa_operation_unref(o)

    def pa_context_get_source_info_by_name(self, source_name):
        o = pa_context_get_source_info_by_name(self._context, source_name, self._pa_source_info_cb, False)
        pa_operation_unref(o)

    def pa_context_set_default_sink(self, sink_name):
        o = pa_context_set_default_sink(self._context, sink_name, self._pa_context_success_cb, False)
        pa_operation_unref(o)

    def pa_context_move_source_output_by_index(self, source_output_index, source_index):
        pa_context_move_source_output_by_index(self._context, source_output_index, source_index, self._pa_context_success_cb, None)

    def pa_context_set_default_source(self, source_name):
        o = pa_context_set_default_source(self._context, source_name, self._pa_context_success_cb, False)
        pa_operation_unref(o)

if __name__ == '__main__':

    log.basicConfig(level=log.CRITICAL)
    import gtk
    # Turn on gtk threading
    gtk.gdk.threads_init()

    pac = PulseAudioConnection("Test")
    pac.connect()

    gtk.main()
    
