
import os
import gtk
from earcandy.util.DesktopFiles import DesktopFiles
import logging

log = logging.getLogger('WindowApplication')
log.setLevel(logging.WARNING)

class Application():
    def __init__(self, pid, command, name, desktop_files, icon):
        self.command = os.path.basename(command.lower().strip())
        self.name = name.lower().strip()
        self.role = ""
        self.icon = icon
        self.icon_name = ""
        self.description = name

        # current application window info
        self.pid = pid
        self.window_name = ""
        self.x = 0
        self.y = 0
        self.fullscreen = False
        
        self.__match_desktop(desktop_files)
        return

    def __match_desktop(self,  desktop_files):

        #print "checking desktop files for match....", self.name
        # Try looking up the application list
        for a in desktop_files:
            ex = a.get_exec_array()[0].lower()

            # Check for pulse audio settings first...
            if a.get("X-PulseAudio-Properties"):
                self.role = a.get("X-PulseAudio-Properties")
                break

            if a.get("Categories") and len(a.get("Categories")) == 1 and a.get("Categories")[0] == "Core":
                # skip entries that are core only
                pass
            else:
                if a.get("X-GNOME-Bugzilla-Product") == self.name or ex == self.name or ex == self.command or a.get("Name").lower() == self.name or a.get("Name").lower() == self.command or ex + ".real" == self.command :
                    self.icon_name = a.get("Icon")
                    self.description = a.get("Name")
                    self.role = self.__desktop_categories_to_role( a.get("Categories") )
                    log.debug("WW :: desktop file : %s" % a.filename)
                    break

        if self.command == "skype.real":
            self.role = "phone"
        
        log.debug("WW :: role : %s" % self.role)

    def __desktop_categories_to_role(self, categories):
        if categories:
            for role in categories:
                if "Telephony" in categories or "InstantMessaging" in categories:
                    return "phone"
                if "Music" in categories:
                    return "music"
                if "Video" in categories:
                    return "video"
                if "AudioVideo" in categories:
                    return "music"             
    
        return ""
