# titan.core

TTCN-3 is a standardized, modular language specifically designed for testing. 
Eclipse Titan offers a free and open source (FOSS) compiler both for TTCN-3 and for 
ASN.1 (Abstract Syntax Notation One).

# Standards page (also including downloadable code):

* http://www.ttcn-3.org/

# Main project page:

* https://projects.eclipse.org/projects/tools.titan

# Community forum:

* https://www.eclipse.org/forums/index.php/f/297/

# Bugzilla

* https://bugs.eclipse.org/bugs/buglist.cgi?field0-0-0=product&field0-0-1=component&list_id=15328562&order=changeddate%2Cbug_status%20DESC%2Creporter%20DESC%2Ccomponent%2Cassigned_to%2Cpriority%2Cbug_severity&query_based_on=&query_format=advanced&type0-0-0=substring&type0-0-1=substring&value0-0-0=Titan&value0-0-1=Titan

# Openhub page:

* https://www.openhub.net/p/eclipse_titan/


## Introductory video of a presentation about Titan held at EclipseCon 2014: 
* https://www.youtube.com/watch?v=2knzZuwzn-Y.

## Titan Datasheet on polarsys.org:
http://polarsys.org/sites/default/files/custom_uploads/TITAN%20Datasheet%20A4%202.1.pdf

## Ericsson TTCN-3 Course, Presentation material
http://www.ttcn-3.org/files/TTCN3_P.pdf

## Ericsson TTCN-3 Course, Presentation material, part II (Titan specifics)
https://www.eclipse.org/downloads/download.php?file=/titan/TITAN_User_P.pdf




## Binaries for a number of Linux platforms can be downloaded from:


* https://projects.eclipse.org/projects/tools.titan/downloads


# Related products:

## Eclipse IDE plug-ins (Designer, Executor, LogViewer, Titanium):

Source code:

* https://github.com/eclipse/titan.EclipsePlug-ins

Compressed update site and SHA512 checksum:

* https://projects.eclipse.org/projects/tools.titan/downloads
 
## Test Ports:
 
* https://github.com/eclipse/titan.TestPorts.Common_Components.Abstract_Socket
* https://github.com/eclipse/titan.TestPorts.Common_Components.Socket-API
* https://github.com/eclipse/titan.TestPorts.HTTPmsg
* https://github.com/eclipse/titan.TestPorts.IPL4asp
* https://github.com/eclipse/titan.TestPorts.LANL2asp
* https://github.com/eclipse/titan.TestPorts.LDAPasp_RFC4511
* https://github.com/eclipse/titan.TestPorts.LDAPmsg
* https://github.com/eclipse/titan.TestPorts.PCAPasp
* https://github.com/eclipse/titan.TestPorts.PIPEasp
* https://github.com/eclipse/titan.TestPorts.SCTPasp
* https://github.com/eclipse/titan.TestPorts.SIPmsg
* https://github.com/eclipse/titan.TestPorts.SQLasp
* https://github.com/eclipse/titan.TestPorts.SSHCLIENTasp
* https://github.com/eclipse/titan.TestPorts.STDINOUTmsg
* https://github.com/eclipse/titan.TestPorts.SUNRPCasp
* https://github.com/eclipse/titan.TestPorts.TCPasp
* https://github.com/eclipse/titan.TestPorts.TELNETasp
* https://github.com/eclipse/titan.TestPorts.UDPasp
* https://github.com/eclipse/titan.TestPorts.UNIX_DOMAIN_SOCKETasp
* git://git.eclipse.org/gitroot/titan/titan.TestPorts.GPIO.git
* git://git.eclipse.org/gitroot/titan/titan.TestPorts.MTP3.git
* git://git.eclipse.org/gitroot/titan/titan.TestPorts.SocketCANasp.git 
 
 
## Protocol Modules:
 
* https://github.com/eclipse/titan.ProtocolModules.COMMON  
* https://github.com/eclipse/titan.ProtocolModules.DHCP
* https://github.com/eclipse/titan.ProtocolModules.DHCPv6
* https://github.com/eclipse/titan.ProtocolModules.DIAMETER_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.DNS
* https://github.com/eclipse/titan.ProtocolModules.FrameRelay
* https://github.com/eclipse/titan.ProtocolModules.H248_v2
* https://github.com/eclipse/titan.ProtocolModules.HTTP2.0
* https://github.com/eclipse/titan.ProtocolModules.ICAP
* https://github.com/eclipse/titan.ProtocolModules.ICMP
* https://github.com/eclipse/titan.ProtocolModules.ICMPv6
* https://github.com/eclipse/titan.ProtocolModules.IKEv2
* https://github.com/eclipse/titan.ProtocolModules.IMAP_4rev1
* https://github.com/eclipse/titan.ProtocolModules.IP
* https://github.com/eclipse/titan.ProtocolModules.IPsec
* https://github.com/eclipse/titan.ProtocolModules.IUA
* https://github.com/eclipse/titan.ProtocolModules.JSON_v07_2006
* https://github.com/eclipse/titan.ProtocolModules.L2TP
* https://github.com/eclipse/titan.ProtocolModules.M3UA
* https://github.com/eclipse/titan.ProtocolModules.MIME
* https://github.com/eclipse/titan.ProtocolModules.MSRP
* https://github.com/eclipse/titan.ProtocolModules.PPP
* https://github.com/eclipse/titan.ProtocolModules.ProtoBuff
* https://github.com/eclipse/titan.ProtocolModules.RADIUS_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.RTP
* https://github.com/eclipse/titan.ProtocolModules.RTSP
* https://github.com/eclipse/titan.ProtocolModules.SMPP
* https://github.com/eclipse/titan.ProtocolModules.SMTP
* https://github.com/eclipse/titan.ProtocolModules.SNMP
* https://github.com/eclipse/titan.ProtocolModules.SRTP
* https://github.com/eclipse/titan.ProtocolModules.TCP
* https://github.com/eclipse/titan.ProtocolModules.UDP
* https://github.com/eclipse/titan.ProtocolModules.WebSocket
* https://github.com/eclipse/titan.ProtocolModules.XMPP
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.DSS1_ETSI.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.DUA.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.EAP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.GRE.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.HTTP2.git
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.M2PA.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.NDP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.NTAF.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.ROSE.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.SDP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.STUN_RFC5389.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.SUA.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.TLS.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.WTP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.SCTP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.CoAP.git 
* git://git.eclipse.org/gitroot/titan/titan.ProtocolModules.MQTT.git 


## Protocol Emulations

* git://git.eclipse.org/gitroot/titan/titan.ProtocolEmulations.SCCP.git
* git://git.eclipse.org/gitroot/titan/titan.ProtocolEmulations.M3UA.git

## Libraries:

* https://github.com/eclipse/titan.Libraries.TCCUsefulFunctions
* git://git.eclipse.org/gitroot/titan/titan.Libraries.TLS.git 

## Miscellaneous projects: 

* https://github.com/eclipse/titan.misc
(VSBOT, SIP_ETSI,DIAMETER_Rx_ETSI, CoAP Conformance test cases,  CoAP and MQTT protocol modules for IOT-moved to Eclipse git,  more to come...) 
