# titan.core

TTCN-3 is a standardized, modular language specifically designed for testing.
Eclipse Titan offers a free and open source (FOSS) compiler both for TTCN-3 and for
ASN.1 (Abstract Syntax Notation One).

# Standards page (also including downloadable code):

* http://www.ttcn-3.org/

# Main project page:

* https://projects.eclipse.org/projects/tools.titan

# Community forum:

* https://www.eclipse.org/forums/index.php/f/297/

# Issue tracker

* Bugzilla bugs have been migrated to the gitlab repository as issues: https://gitlab.eclipse.org/eclipse/titan/titan.core/-/issues

* The old (arcived) Bugzilla bugs: https://bugs.eclipse.org/bugs/buglist.cgi?field0-0-0=product&field0-0-1=component&list_id=15328562&order=changeddate%2Cbug_status%20DESC%2Creporter%20DESC%2Ccomponent%2Cassigned_to%2Cpriority%2Cbug_severity&query_based_on=&query_format=advanced&type0-0-0=substring&type0-0-1=substring&value0-0-0=Titan&value0-0-1=Titan

# Openhub page:

* https://www.openhub.net/p/eclipse_titan/


## Introductory video of a presentation about Titan held at EclipseCon 2014:
* https://www.youtube.com/watch?v=2knzZuwzn-Y.

## Titan Datasheet on polarsys.org:
https://polarsys.org/sites/default/files/custom_uploads/TITAN%20Datasheet%20A4%202.1.pdf

## Ericsson TTCN-3 Course, Presentation material
https://www.eclipse.org/downloads/download.php?file=/titan/TTCN3_Course_PartI_EclipseLicensed.pdf

## Ericsson TTCN-3 Course, Presentation material, part II (Titan specifics)
https://www.eclipse.org/downloads/download.php?file=/titan/TTCN3_Course_PartII_EclipseLicensed.pdf




## Binaries for a number of Linux platforms can be downloaded from:


* https://projects.eclipse.org/projects/tools.titan/downloads

# Contributor workflow:

* https://docs.gitlab.com/ee/user/project/merge_requests/

# Related products:

## Eclipse IDE plug-ins (Designer, Executor, LogViewer, Titanium):

Source code:

* https://gitlab.eclipse.org/eclipse/titan/titan.EclipsePlug-ins

Compressed update site and SHA512 checksum:

* https://projects.eclipse.org/projects/tools.titan/downloads

## Test Ports:

* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.Common_Components.Abstract_Socket
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.Common_Components.Socket-API
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.HTTPmsg
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.IPL4asp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.LANL2asp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.LDAPasp_RFC4511
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.LDAPmsg
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.PCAPasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.PIPEasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SCTPasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SIPmsg
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SQLasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SSHCLIENTasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.STDINOUTmsg
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SUNRPCasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.TCPasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.TELNETasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.UDPasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.UNIX_DOMAIN_SOCKETasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.GPIO
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.MTP3asp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.Serial
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.SocketCANasp
* https://gitlab.eclipse.org/eclipse/titan/titan.TestPorts.Thrift_TPG


## Protocol Modules:

* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.COMMON
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DHCP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DHCPv6
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DIAMETER_ProtocolModule_Generator
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DNS
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.FrameRelay
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.H248_v2
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.HTTP2.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ICAP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ICMP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ICMPv6
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.IKEv2
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.IMAP_4rev1
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.IP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.IPsec
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.IUA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.JSON_v07_2006
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.JSON_Web_Signature
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.L2TP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.M3UA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.MIME
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.MSRP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.PPP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ProtoBuff
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.RADIUS_ProtocolModule_Generator
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.RTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.RTSP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SMPP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SMTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SNMP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SRTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.TCP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.UDP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.WebSocket
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.XMPP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.BSSAPP_v7.3.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.BSSGP_v13.0.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.BSSMAP_v11.2.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.CoAP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DSS1_ETSI
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.DUA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.EAP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.GCP_31r1
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.GRE
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.GTP_v13.5.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.GTPv2_v13.7.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.GTPv2_v15.2.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.HTTP2
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ISUP_Q.762
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.LLC_v7.1.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.M2PA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.M2UA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.MQTT
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.MobileL3_v13.4.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.MongoDB
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.NAS_EPS_15.2.0.1
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.NDP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.NS_v7.3.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.NTAF
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.OPC_UA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.PFCP_v15.1.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.ROSE
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SCTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SDP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SGsAP_13.2.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SNDCP_v7.0.0
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.STOMP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.STUN
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.STUN_RFC5389
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.SUA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.TLS
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.V5
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.WTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.XML_RPC
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.XTDP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29502_Nsmf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29503_Nudm_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29508_Nsmf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29509_Nausf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29510_Nnrf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29511_N5g_eir_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29512_Npcf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29514_Npcf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29518_Namf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29520_Nnwdaf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29571_CommonData_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29572_Nlmf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS29594_Nchf_v15
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolModules.5G_system_TS32291_Nchf_v15


## Protocol Emulations

* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolEmulations.M3UA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolEmulations.SCCP
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolEmulations.SUA
* https://gitlab.eclipse.org/eclipse/titan/titan.ProtocolEmulations.SCTP

## Libraries:

* https://gitlab.eclipse.org/eclipse/titan/titan.Libraries.TCCUsefulFunctions
* https://gitlab.eclipse.org/eclipse/titan/titan.Libraries.CLL
* https://gitlab.eclipse.org/eclipse/titan/titan.Libraries.ServiceFramework
* https://gitlab.eclipse.org/eclipse/titan/titan.Libraries.TLS
* https://gitlab.eclipse.org/eclipse/titan/titan.Libraries.Web_GUI

## Application Libraries:

* https://gitlab.eclipse.org/eclipse/titan/titan.ApplicationLibraries.CoAP
* https://gitlab.eclipse.org/eclipse/titan/titan.ApplicationLibraries.HTTP
* https://gitlab.eclipse.org/eclipse/titan/titan.ApplicationLibraries.LWM2M
* https://gitlab.eclipse.org/eclipse/titan/titan.ApplicationLibraries.MBT
* https://gitlab.eclipse.org/eclipse/titan/titan.ApplicationLibraries.MQTT

## Applications:

* https://gitlab.eclipse.org/eclipse/titan/titan.Applications.IoT_Functiontest_Framework
* https://gitlab.eclipse.org/eclipse/titan/titan.Applications.IoT_Loadtest_Framework
* https://gitlab.eclipse.org/eclipse/titan/titan.Applications.RIoT

## Servers

* https://gitlab.eclipse.org/eclipse/titan/titan.Servers.GTP_Tunnel_Daemon
* https://gitlab.eclipse.org/eclipse/titan/titan.Servers.IP_Daemon_Dynamic
* https://gitlab.eclipse.org/eclipse/titan/titan.Servers.SCTP_Daemon_Dynamic

## Miscellaneous projects:

* https://gitlab.eclipse.org/eclipse/titan/titan.misc
(VSBOT, SIP_ETSI,DIAMETER_Rx_ETSI, CoAP Conformance test cases,  CoAP and MQTT protocol modules for IOT-moved to Eclipse git,  more to come...)

