/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Provide low level serial communication functions
 *
 * Author :         Andreas Schwier (ASC)
 *
 * Last modified:   21.Jan 2000
 *
 *****************************************************************************/

#ifndef _sercom_h_
#define _sercom_h_

#define ERR_RS232OPEN         -1
#define ERR_RS232PARAM        -2

#ifdef WIN32
    typedef void *HANDLE;
    void usleep(int ms);
#else
#ifndef HANDLE
    #define HANDLE int
#endif
#endif

int rs232Open(HANDLE *fh, char *port, long baud, char parity, int bits, int stopbits, long timeout);
int rs232Mode(HANDLE fh, long baud, char parity, int bits, int stopbits, long timeout);
int rs232LineControl(HANDLE fh, int dtr, int rts);
int rs232LineTest(HANDLE fh, int *dsr, int *cts);
int rs232Read(HANDLE fh, unsigned char *buff, int len);
int rs232Write(HANDLE fh, unsigned char *buff, int len);
int rs232Drain(HANDLE fh);
int rs232Flush(HANDLE fh);
int rs232Close(HANDLE fh);

#endif
