#ifndef _ECS_MAILLAGE_PRIV_H_
#define _ECS_MAILLAGE_PRIV_H_

/*============================================================================
 *  Definition privee de la structure `_ecs_maillage_t' decrivant un maillage
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_connect_publ.h"
#include "ecs_entmail_publ.h"
#include "ecs_famille_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_maillage_publ.h"



/*============================================================================
 *                       Definition de macros
 *============================================================================*/



/*============================================================================
 *                       Definition de la structure
 *============================================================================*/

struct _ecs_maillage_t {

  ecs_dim_t       dim_e                    ; /* Dimension spatiale (2 ou 3)   */

  ecs_connect_t * connect[ECS_CONNECT_FIN] ; /* Tableau des connectivites     */

  ecs_entmail_t * entmail[ECS_ENTMAIL_FIN] ; /* Tabl. des entites de maillage */

  ecs_famille_t * famille[ECS_FAMILLE_FIN] ; /* Tableau des listes chainees   */
                                             /* des familles, par entite      */

} ;


/*============================================================================
 *
 *  .================================.  .===================================.
 *  |                                |  |                                   |
 *  |         Connectivites          |  |      Entites de maillage          |
 *  |                                |  |                                   |
 *  |================================|  |===================================|
 *  | ECS_CONNECT_ARE_SOM            |  | ECS_ENTMAIL_SOM  : entite sommet  |
 *  | (Aretes -> Sommets)            |  |                                   |
 *  |--------------------------------|  |-----------------------------------|
 *  | ECS_CONNECT_FAC_SOM            |  | ECS_ENTMAIL_ARE  : entite arete   |
 *  | (Faces  -> Sommets)            |  | (Exactement 2 sommets)            |
 *  |--------------------------------|  |-----------------------------------|
 *  | ECS_CONNECT_FAC_ARE            |  | ECS_ENTMAIL_FAC  : entite face    |
 *  | (Faces  -> Aretes)             |  | (Surface a 3 sommets ou plus)     |
 *  |--------------------------------|  |-----------------------------------|
 *  | ECS_CONNECT_CEL_SOM            |  | ECS_ENTMAIL_CEL  : entite cellule |
 *  | (Cellules -> Sommets)          |  | (Volume  a 4 sommets ou plus)     |
 *  |--------------------------------|  `-----------------------------------'
 *  |  ECS_CONNECT_CEL_FAC           |
 *  |  (Cellules -> Faces)           |
 *  `================================'
 *
 *============================================================================*/


/*============================================================================
 *
 *                         Pour un maillage definit en
 *
 *----------------------------------------------------------------------------
 *        connectivite nodale          |      connectivite descendante
 *-------------------------------------|--------------------------------------
 * ECS_CONNECT_ARE_SOM = NULL ou non   |  ECS_CONNECT_ARE_SOM = non NULL
 * ECS_CONNECT_FAC_SOM = NULL ou non   |  ECS_CONNECT_FAC_SOM =     NULL
 * ECS_CONNECT_FAC_ARE =     NULL      |  ECS_CONNECT_FAC_ARE = non NULL
 * ECS_CONNECT_CEL_SOM = non NULL      |  ECS_CONNECT_CEL_SOM =     NULL
 *                           (dim=3)   |
 * ECS_CONNECT_CEL_FAC =     NULL      |  ECS_CONNECT_CEL_FAC = non NULL
 *                                     |                            (dim=3)
 *============================================================================*/


/*============================================================================
 *
 * Les valeurs des champs `famille' sont les numeros des familles
 *  numerotees a partir de `1' comme suit :
 *  - en commencant par les familles des cellules
 *  - puis          par les familles des faces
 *  - puis          par les familles des aretes
 *  - puis          par les familles des sommets
 *============================================================================*/


#endif /* _ECS_MAILLAGE_PRIV_H_ */
