#ifndef _ECS_SELECT_FAC_PUBL_H_
#define _ECS_SELECT_FAC_PUBL_H_

/*============================================================================
 *  Definition publique de la structure `ecs_select_fac_t' contenant
 *   les listes des couleurs et des groupes des faces selectionnees
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                       Definition de macros
 *============================================================================*/


/*============================================================================
 *                         Definitions d'enumerations
 *============================================================================*/

typedef enum {

  ECS_SELECT_FAC_TOUT ,
  ECS_SELECT_FAC_INT  ,
  ECS_SELECT_FAC_BORD

} ECS_SELECT_FAC_E ;


/*============================================================================
 *                       Definition de la structure
 *============================================================================*/

typedef struct _ecs_select_fac_t {

  ecs_tab_int_t     liste_couleur_fac ;
  ecs_tab_char_t    liste_groupe_fac  ;
  ecs_bool_t        inv_selection     ;
  ECS_SELECT_FAC_E  type_sel          ;

} ecs_select_fac_t ;


#endif /* _ECS_SELECT_FAC_PUBL_H_ */
