#ifndef _ECS_VEC_DEF_RC_H_
#define _ECS_VEC_DEF_RC_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associees aux structures `ecs_vec_int_t' et `ecs_vec_real_t' decrivant
 *   les vecteurs indexes entier et reel
 *   et propres aux vecteurs indexes
 *      lies aux champs principaux de type "definition"
 *  Ces fonctions participent a la fonctionnalite de "recollement conforme"
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_param_rc_glob.h"
#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_publ.h"
#include "ecs_vec_real_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui recolle les faces non conformes
 *
 *  Les listes des faces nouvelles ou modifies sont construites (et alloues)
 *  ici ; les structures liste_fac_new et liste_fac_mod correspondantes sont
 *  donc vides en entre ; idem pour liste_fac_err qui indiquera les indices
 *  des faces pour lesquelles le dcoupage en sous-faces a chou
 *
 *  On prend en entre soit une dfinition de type "visibilit" entre faces
 *   recoller (par exemple une filiation), ou alors une simple liste de
 *  faces slectionnes. L'un de vec_fac_vis et tab_fac_select doit donc
 *  tre  NULL, et l'autre non.
 *----------------------------------------------------------------------------*/

void ecs_vec_def__recolle
(
       ecs_vec_int_t   * *const vec_def_fac     , /* <-> Df. des faces       */
       ecs_vec_int_t   * *const vec_def_are     , /* <-> Df. des artes      */
       ecs_vec_real_t  * *const vec_def_som     , /* <-> Df. des sommets     */
       ecs_vec_int_t   * *const vec_fac_old_new , /* <-  Renum. faces         */
       ecs_vec_int_t     *const vec_fac_vis     , /*  -> Visibilit faces     */
       ecs_vec_int_t   * *const vec_fac_perio   , /*  -> Correspondance perio */
       ecs_vec_int_t   * *const vec_are_perio   , /*  -> Correspondance perio */
       ecs_vec_int_t   * *const vec_som_perio   , /*  -> Correspondance perio */
 const ecs_tab_int_t     *const tab_fac_select  , /*  -> Faces slectionnes  */
       ecs_tab_int_t     *const liste_fac_new   , /* <-  Nouvelles faces      */
       ecs_tab_int_t     *const liste_fac_mod   , /* <-  Faces modifies      */
       ecs_tab_int_t     *const liste_fac_err   , /* <-  Faces non dcoupes  */
 const ecs_param_rc_t           param_rc          /*  -> Param. tolrance     */
) ;


#endif /* _ECS_VEC_DEF_RC_H_ */
