#ifndef _ECS_CHAMP_POST_H_
#define _ECS_CHAMP_POST_H_

/*============================================================================
 *  Prototypes des fonctions
 *   associes  la structure `ecs_champ_t' dcrivant un champ
 *   et ralisant les sorties pour post-traitement
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/

#include "ecs_post_glob.h"
#include "ecs_post_ens_publ.h"

#if defined(HAVE_MED)
#include "ecs_med_publ.h"
#endif /* HAVE_MED */


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction ecrivant les elements d'un champ donne pour le post traitement
 *
 *  Les elements doivent avoir ete tries suivant leur type geometrique
 *----------------------------------------------------------------------------*/

void ecs_champ_post__ecr_elt
(
 const char               *const nom_maillage,
       int                       dim_entite_max,
       ecs_champ_t        *const champ_som,
       ecs_champ_t        *const champ_def,
       ecs_champ_t        *const champ_famille,
       ecs_champ_t        *const champ_def_inf,
       ecs_champ_t        *const champ_famille_inf,
 const ecs_famille_t      *const famille_elt,
 const ecs_famille_t      *const famille_inf,
       ecs_post_type_t           type_post,
       ecs_post_t         *const cas_post
) ;


/*----------------------------------------------------------------------------
 *  Fonction ecrivant les valeurs d'un champ donne pour le post traitement
 *---------------------------------------------------------------------------*/

void ecs_champ_post__ecr_val
(
 const ecs_tab_int_t  *const tab_val,
 const char           *const nom_maillage,
 const char           *const nom_champ,
       ecs_post_t     *const cas_post
) ;


#endif /* _ECS_CHAMP_POST_H_ */
