#ifndef _ECS_POST_PUBL_H_
#define _ECS_POST_PUBL_H_

/*============================================================================
 *  Dfinition de la structure `ecs_post_t' pour post-traitement
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

#include "ecs_config.h"


/*-----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_post_ens_publ.h"
#include "ecs_med_publ.h"
#include "ecs_cgns_publ.h"


/*============================================================================
 *                         Dfinitions d'numerations
 *============================================================================*/

/*  Dfinition d'numration lie au dcoupage pour post-traitement */

typedef enum {

  ECS_POST_FAC_MAX_POLY ,  /* polygones supports, aucun dcoupage ncessaire */
  ECS_POST_FAC_MAX_QUAD ,  /* quadrangles au maximum, dcoupage ventuel      */
  ECS_POST_FAC_MAX_FIN     /* Nombre de cas de dcoupage possibles            */

} ecs_post_fac_dec_t ;


/*  Dfinition d'numration lie au type de post-traitement */

typedef enum {

  ECS_POST_TYPE_VOLUME ,  /* maillage volumique (initial)                    */
  ECS_POST_TYPE_BORD   ,  /* maillage de bord (final)                        */
  ECS_POST_TYPE_INFO   ,  /* maillage d'information (recollement, etc.)      */
  ECS_POST_TYPE_ERREUR    /* maillage d'une zone avec erreur                 */

} ecs_post_type_t ;


/*============================================================================
 *                             Structures de donnes
 *============================================================================*/

/* Structure lie aux options amont de post-traitement */

typedef struct {

  ecs_bool_t  dec_poly    ;  /* Dcoupage des faces polygonales ?             */
  ecs_bool_t  single_part ;  /* Forcer la sortie  une seule part EnSight,
                                ou une seule section CGNS                     */
  ecs_bool_t  text        ;  /* Forcer la sortie en mode texte si disponible  */
  ecs_bool_t  big_endian  ;  /* Forcer la sortie binaire en mode big-endian
                                si possible */
  ecs_bool_t  ecr_type[4] ;  /* Indicateur de sortie des maillages par type   */

} ecs_post_opt_t ;


/* Structure lie aux cas de post-traitement */

typedef struct {

  char            * nom_cas         ;  /* Nom du cas par dfaut               */

  ecs_bool_t        post_ens        ;  /* Indicateur post-traitement Ensight  */
  ecs_post_opt_t    opt_ens         ;  /* Options pour EnSight                */
  ecs_post_ens_t  * cas_ens         ;  /* Cas EnSight associ                 */

#if defined(HAVE_CGNS)

  ecs_bool_t        post_cgns       ;  /* Indicateur post-traitement CGNS     */
  ecs_post_opt_t    opt_cgns        ;  /* Options pour CGNS                   */
  ecs_cgns_t      * cas_cgns        ;  /* Cas CGNS associ                    */

#endif

#if defined(HAVE_MED)

  ecs_bool_t        post_med        ;  /* Indicateur post-traitement MED      */
  ecs_post_opt_t    opt_med         ;  /* Options pour MED                    */
  ecs_med_t       * cas_med         ;  /* Cas MED associ                     */

#endif

} ecs_post_t ;


/*============================================================================
 *                       Dfinition de macros
 *============================================================================*/

#endif /* _ECS_POST_PUBL_H_ */
