/*============================================================================
 *  Definitions des fonctions
 *   associees a la structure `ecs_entmail_t' decrivant une entite de maillage
 *   et realisant les sorties pour post-traitement
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

#include "ecs_config.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <assert.h>
#include <string.h>

/*----------------------------------------------------------------------------
 *  Fichiers `include' systme ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_error.h>
#include <bft_mem.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_chaine_glob.h"
#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_champ_post.h"
#include "ecs_champ_chaine.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail.h"
#include "ecs_entmail_pcp.h"


/*----------------------------------------------------------------------------
 *  Fichier  `include' du  paquetage courant associe au fichier courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_post.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' prives   du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_priv.h"



/*============================================================================
 *                       Prototypes de fonctions privees
 *============================================================================*/


/*============================================================================
 *                             Fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction crivant les connectivits (nodales) des lements
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_elt
(
 const char            *const nom_maillage,
       int                    dim_entite_max,
 const ecs_entmail_t   *const entmail_elt,
 const ecs_entmail_t   *const entmail_inf,
 const ecs_entmail_t   *const entmail_som,
 const ecs_famille_t   *const famille_elt,
 const ecs_famille_t   *const famille_inf,
       ecs_post_type_t        type_post,
       ecs_post_t      *const cas_post
)
{

  ecs_champ_t  * champ_famille_elt ;

  ecs_champ_t  * champ_def_inf ;
  ecs_champ_t  * champ_famille_inf ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/

  if (cas_post == NULL)
    return ;

  assert(entmail_elt != NULL) ;
  assert(entmail_som != NULL) ;


  /* Initialisations */

  champ_famille_elt     = NULL ;

  champ_def_inf         = NULL ;
  champ_famille_inf     = NULL ;


  /* Familles */

  if (entmail_elt->champ[ECS_CHAMP_ATT] != NULL)

    champ_famille_elt
      = ecs_champ_chaine__trouve_nom(entmail_elt->champ[ECS_CHAMP_ATT],
                                     ECS_CHAMP_NOM_FAMILLE) ;


  /* Connectivit et familles entmail_inf */

  if (entmail_inf != NULL) {

    if (entmail_inf->champ[ECS_CHAMP_ATT] != NULL) {

      champ_famille_inf
        = ecs_champ_chaine__trouve_nom(entmail_inf->champ[ECS_CHAMP_ATT],
                                       ECS_CHAMP_NOM_FAMILLE) ;

      if (champ_famille_inf != NULL) {

        champ_def_inf = entmail_inf->champ[ECS_CHAMP_DEF] ;

      }

    }

  }


  /* criture du maillage */

  ecs_champ_post__ecr_elt(nom_maillage,
                          dim_entite_max,
                          entmail_som->champ[ECS_CHAMP_DEF],
                          entmail_elt->champ[ECS_CHAMP_DEF],
                          champ_famille_elt,
                          champ_def_inf,
                          champ_famille_inf,
                          famille_elt,
                          famille_inf,
                          type_post,
                          cas_post) ;

}


/*----------------------------------------------------------------------------
 *  Impression d'une variable en post-traitement valant 1 pour les entits
 *  enumres dans cette liste, 0 pour les autres.
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_tab_liste
(
       ecs_entmail_t   *const this_entmail,
 const char            *const nom_maillage,
 const char            *const nom_var ,
 const ecs_tab_int_t          liste_entites,
       ecs_post_t      *const cas_post
)
{

  size_t         ind ;
  ecs_tab_int_t  tab_val ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/


  assert(cas_post != NULL) ;

  tab_val.nbr
    = ecs_entmail__ret_nbr_ele(this_entmail) ;

  BFT_MALLOC(tab_val.val, tab_val.nbr, ecs_int_t) ;

  for (ind = 0 ; ind < tab_val.nbr ; ind++)
    tab_val.val[ind] = 0 ;

  for (ind = 0 ; ind < liste_entites.nbr ; ind++)
    tab_val.val[liste_entites.val[ind]] = 1 ;


  ecs_entmail_post__ecr_tab_int(nom_maillage,
                                nom_var,
                                &tab_val,
                                cas_post) ;

  BFT_FREE(tab_val.val) ;
  tab_val.nbr = 0 ;

}


/*----------------------------------------------------------------------------
 *  Impression d'un tableau de variables en post-traitement
 *----------------------------------------------------------------------------*/

void ecs_entmail_post__ecr_tab_int
(
 const char            *const nom_maillage,
 const char            *const nom_var,
       ecs_tab_int_t   *const tab_val,
       ecs_post_t      *const cas_post
)
{

  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/

  if (cas_post == NULL)
    return ;


  /* Ecriture du champ sur fichier pour post-traitement */

  ecs_champ_post__ecr_val(tab_val,
                          nom_maillage,
                          nom_var,
                          cas_post) ;

}


/*============================================================================
 *                              Fonctions prives
 *============================================================================*/
