/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009, 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#include "save_montage_dialog.h"



UI_SaveMontagewindow::UI_SaveMontagewindow(QWidget *parent)
{
  int i;

  mainwindow = (UI_Mainwindow *)parent;

  if(mainwindow->files_open==1)
  {
    SaveMontageDialog = NULL;
    SaveButtonClicked();
    return;
  }

  SaveMontageDialog = new QDialog;

  SaveMontageDialog->setMinimumSize(QSize(800, 180));
  SaveMontageDialog->setMaximumSize(QSize(800, 180));
  SaveMontageDialog->setWindowTitle("Save montage");
  SaveMontageDialog->setModal(TRUE);
  SaveMontageDialog->setAttribute(Qt::WA_DeleteOnClose, TRUE);

  label1 = new QLabel(SaveMontageDialog);
  label1->setGeometry(QRect(10, 10, 780, 25));
  label1->setText("Choose from which file you want to save the montage:");

  filelist = new QListWidget(SaveMontageDialog);
  filelist->setGeometry(QRect(10, 35, 780, 75));
  filelist->setSelectionBehavior(QAbstractItemView::SelectRows);
  filelist->setSelectionMode(QAbstractItemView::SingleSelection);
  for(i=0; i<mainwindow->files_open; i++)
  {
    new QListWidgetItem(mainwindow->edfheaderlist[i]->filename, filelist);
  }

  SaveButton = new QPushButton(SaveMontageDialog);
  SaveButton->setGeometry(QRect(10, 140, 100, 25));
  SaveButton->setText("Save");

  CloseButton = new QPushButton(SaveMontageDialog);
  CloseButton->setGeometry(QRect(690, 140, 100, 25));
  CloseButton->setText("Close");

  QObject::connect(CloseButton,  SIGNAL(clicked()), SaveMontageDialog, SLOT(close()));
  QObject::connect(SaveButton,   SIGNAL(clicked()), this,              SLOT(SaveButtonClicked()));

  filelist->setCurrentRow(mainwindow->files_open - 1);

  SaveMontageDialog->exec();
}



void UI_SaveMontagewindow::SaveButtonClicked()
{
  int i, j, k, n, len;

  char mtg_path[1024],
       *label;

  FILE *mtgfile;

  if(mainwindow->files_open==1)  n = 0;
  else  n = filelist->currentRow();

  QFileDialog fchooser;

  fchooser.setConfirmOverwrite(1);
  fchooser.setFileMode(QFileDialog::AnyFile);
  fchooser.setAcceptMode(QFileDialog::AcceptSave);
  fchooser.setWindowTitle("Save");
  fchooser.setLabelText(QFileDialog::FileName, "Name of montage:");
  fchooser.setDefaultSuffix("mtg");
#ifdef Q_WS_X11
  fchooser.setDirectory(getenv("HOME"));
#endif
#ifdef Q_WS_MAC
  fchooser.setDirectory(getenv("HOME"));
#endif
  fchooser.setFilter("Montage files (*.mtg *.MTG)");

  if(mainwindow->recent_montagedir[0]!=0)
  {
    fchooser.setDirectory(mainwindow->recent_montagedir);
  }

  if(!(fchooser.exec() == QDialog::Accepted))
  {
    return;
  }

  strcpy(mtg_path, fchooser.selectedFiles().at(0).toLatin1().data());

  strcpy(mainwindow->recent_montagedir, mtg_path);
  len = strlen(mainwindow->recent_montagedir);
  if(len)
  {
    for(i=len-1; i>=0; i--)
    {
      if((mainwindow->recent_montagedir[i] == '/')||(mainwindow->recent_montagedir[i] == '\\'))
      {
        break;
      }
    }
    mainwindow->recent_montagedir[i+1] = 0;
  }

  mtgfile = fopen64(mtg_path, "wb");
  if(mtgfile==NULL)
  {
    UI_Messagewindow popuperror("Error", "Error, can not open file for writing.");

    return;
  }

  fprintf(mtgfile, "<?xml version=\"1.0\"?>\n<" PROGRAM_NAME "_montage>\n");

  for(i=0; i<mainwindow->signalcomps; i++)
  {
    if(!strcmp(mainwindow->signalcomp[i]->edfhdr->filename, mainwindow->edfheaderlist[n]->filename))
    {
      fprintf(mtgfile, "  <signalcomposition>\n");

      fprintf(mtgfile, "    <num_of_signals>%i</num_of_signals>\n", mainwindow->signalcomp[i]->num_of_signals);

      fprintf(mtgfile, "    <voltpercm>%f</voltpercm>\n", mainwindow->signalcomp[i]->voltpercm);

      fprintf(mtgfile, "    <screen_offset>%f</screen_offset>\n", mainwindow->signalcomp[i]->screen_offset);

      fprintf(mtgfile, "    <color>%i</color>\n", mainwindow->signalcomp[i]->color);

      fprintf(mtgfile, "    <filter_cnt>%i</filter_cnt>\n", mainwindow->signalcomp[i]->filter_cnt);

      fprintf(mtgfile, "    <fidfilter_cnt>%i</fidfilter_cnt>\n", mainwindow->signalcomp[i]->fidfilter_cnt);

      for(j=0; j<mainwindow->signalcomp[i]->num_of_signals; j++)
      {
        fprintf(mtgfile, "    <signal>\n");

        fprintf(mtgfile, "      <label>");
        label = mainwindow->signalcomp[i]->edfhdr->edfparam[mainwindow->signalcomp[i]->edfsignal[j]].label;
        for(k=0; label[k]!=0; k++)
        {
          if(label[k]=='<')
          {
            fprintf(mtgfile, "&lt");
          }
          else  if(label[k]=='&')
                {
                  fprintf(mtgfile, "&amp");
                }
                else
                {
                  fputc(label[k], mtgfile);
                }
        }
        fprintf(mtgfile, "</label>\n");

        fprintf(mtgfile, "      <factor>%i</factor>\n", mainwindow->signalcomp[i]->factor[j]);

        fprintf(mtgfile, "    </signal>\n");
      }

      for(j=0; j<mainwindow->signalcomp[i]->filter_cnt; j++)
      {
        fprintf(mtgfile, "    <filter>\n");

        fprintf(mtgfile, "      <LPF>%i</LPF>\n", mainwindow->signalcomp[i]->filter[j]->is_LPF);

        fprintf(mtgfile, "      <frequency>%.16f</frequency>\n", mainwindow->signalcomp[i]->filter[j]->cutoff_frequency);

        fprintf(mtgfile, "    </filter>\n");
      }

      for(j=0; j<mainwindow->signalcomp[i]->fidfilter_cnt; j++)
      {
        fprintf(mtgfile, "    <fidfilter>\n");

        fprintf(mtgfile, "      <type>%i</type>\n", mainwindow->signalcomp[i]->fidfilter_type[j]);

        fprintf(mtgfile, "      <frequency>%.16f</frequency>\n", mainwindow->signalcomp[i]->fidfilter_freq[j]);

        fprintf(mtgfile, "      <frequency2>%.16f</frequency2>\n", mainwindow->signalcomp[i]->fidfilter_freq2[j]);

        fprintf(mtgfile, "      <ripple>%.16f</ripple>\n", mainwindow->signalcomp[i]->fidfilter_ripple[j]);

        fprintf(mtgfile, "      <order>%i</order>\n", mainwindow->signalcomp[i]->fidfilter_order[j]);

        fprintf(mtgfile, "      <model>%i</model>\n", mainwindow->signalcomp[i]->fidfilter_model[j]);

        fprintf(mtgfile, "    </fidfilter>\n");
      }

      fprintf(mtgfile, "  </signalcomposition>\n");
    }
  }

  fprintf(mtgfile, "</" PROGRAM_NAME "_montage>\n");

  fclose(mtgfile);

  if(SaveMontageDialog!=NULL) SaveMontageDialog->close();
}







