/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2010 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/




#ifndef IMPORTANNOTATIONSFORM1_H
#define IMPORTANNOTATIONSFORM1_H



#include <QApplication>
#include <QObject>
#include <QFileDialog>
#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QSpinBox>
#include <QComboBox>
#include <QPushButton>
#include <QRadioButton>
#include <QCheckBox>
#include <QGroupBox>
#include <QVBoxLayout>
#include <QHBoxLayout>


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "mainwindow.h"
#include "popup_messagewindow.h"
#include "utc_date_time.h"
#include "edf_annot_list.h"
#include "utils.h"
#include "annotations_dock.h"
#include "xml.h"



class UI_Mainwindow;



struct import_annotations_var_block
{
  char separator[4];
  int format;
  int onsettimeformat;
  int onsetcolumn;
  int descriptioncolumn;
  int datastartline;
};



class UI_ImportAnnotationswindow : public QObject
{
  Q_OBJECT

public:

UI_ImportAnnotationswindow(QWidget *parent);

UI_Mainwindow  *mainwindow;

private:

QDialog        *ImportAnnotsDialog;

QLabel         *SeparatorLabel,
               *OnsetColumnLabel,
               *DescriptionColumnLabel,
               *DatastartLabel,
               *OnsetTimeLabel;

QLineEdit      *SeparatorLineEdit;

QSpinBox       *OnsetColumnSpinBox,
               *DescriptionColumnSpinBox,
               *DatastartSpinbox;

QComboBox      *RelativeTimeComboBox;

QGroupBox      *formatGroupBox,
               *asciiSettingsGroupBox;

QVBoxLayout    *formatVBoxLayout,
               *asciiSettingsVBoxLayout;

QHBoxLayout    *asciiSettingsHBoxLayout1,
               *asciiSettingsHBoxLayout2,
               *asciiSettingsHBoxLayout3,
               *asciiSettingsHBoxLayout4,
               *asciiSettingsHBoxLayout5;

QRadioButton   *CSVRadioButton,
               *XMLRadioButton;

QCheckBox      *IgnoreConsecutiveCheckBox;

QPushButton    *CloseButton,
               *ImportButton;


private slots:

void ImportButtonClicked();
void outputformatRadioButtonClicked(bool);

};



#endif




