/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __TPushParser_hh__
#define __TPushParser_hh__

#include <list>
#include <stack>
#include "TToken.hh"
#include "APushParser.hh"
#include "TDictionary.hh"
#include "TDocument.hh"
#include "TNode.hh"

class TPushParser : public APushParser
{
public:
  TPushParser(class ALogger&, const class TDictionary&);
  TPushParser(class ALogger&, class AMathMLFactory&, const class TDictionary&);
  virtual ~TPushParser();

  virtual void reset(void);
  virtual void push(const TToken&);
  virtual std::string drop(bool);
  virtual void setCursorHint(const std::string&);
  virtual bool hideCursor(void);
  virtual bool showCursor(void);

  virtual bool thaw(void);

  DOM::Document document(void) const { return doc.document().cloneNode(true); }

private:
  void init(void);

  TNode PRIME(void);
  bool isPrimes(const TNode&) const;
  
  bool do_begin(void);
  bool do_end(void);
  bool do_shift(void);
  bool do_align(void);
  bool do_eol(void);
  bool do_parameter(const std::string&);
  bool do_superscript(void);
  bool do_subscript(void);
  bool do_ignorablespace(const std::string&);
  bool do_space(const std::string&);
  bool do_letter(const std::string&);
  bool do_digit(const std::string&);
  bool do_other(const std::string&);
  bool do_active(const std::string&);
  bool do_comment(void);
  bool do_control(const std::string&);
  
  std::string drop_prev_token(bool);
  std::string drop_prev_script(bool);
  std::string drop_prev_group(bool);
  std::string drop_prev_macro(bool);
  std::string drop_prev(bool);
  void rgreplace_father(void);
  std::string do_drop_script(bool);
  std::string do_drop_macro(bool);
  std::string do_drop_groupId(bool);
  std::string do_drop_phantom_group(bool);
  std::string do_drop(bool);

  bool do_cr(void);
  bool do_apostrophe(void);
  void advance(const TNode&);
  bool correctBrace(void);

  bool process(const TToken&);

  struct Frame
  {
    Frame(const TDictionary::Entry& e) : entry(e), pos(0) { };
    Frame(const TDictionary::Entry&e, unsigned p) : entry(e), pos(p) { };
    const TDictionary::Entry& entry;
    unsigned pos;
  };

  std::stack<Frame> frames;
  unsigned  nextId;
  TDocument doc;
  TNode     cursor;
  unsigned  hiddenCursor;
  const class TDictionary& dictionary;
};

#endif // __TPushParser_hh__
