/*
 * Eee Applet 
 * Copyright (C) 2008 Olivier Rolland <billl@users.sourceforge.net>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "eee-monitor.h"

// #define EEE_MONITOR_INTERVAL 1000

/* Signals */
enum
{
  CHANGED,
  N_SIGNALS
};

static void eee_monitor_init       (EeeMonitor      *monitor);
static void eee_monitor_class_init (EeeMonitorClass *klass);

static guint signals[N_SIGNALS];

G_DEFINE_ABSTRACT_TYPE (EeeMonitor, eee_monitor, G_TYPE_OBJECT)

static void
eee_monitor_init (EeeMonitor *monitor)
{
}

static void
eee_monitor_class_init (EeeMonitorClass *klass)
{
  /* Public virtual methods */
  klass->run = NULL;

  /* Signals */
  signals[CHANGED] =
    g_signal_new ("changed",
        G_TYPE_FROM_CLASS (klass),
        G_SIGNAL_RUN_LAST,
        G_STRUCT_OFFSET (EeeMonitorClass, changed),
        NULL, NULL,
        g_cclosure_marshal_VOID__VOID,
        G_TYPE_NONE, 0);
}

gboolean
eee_monitor_run (EeeMonitor *monitor)
{
  EeeMonitorClass *class;
  gboolean        retval = FALSE;

  g_return_val_if_fail (EEE_IS_MONITOR (monitor), FALSE);

  class = EEE_MONITOR_GET_CLASS (monitor);
        
  if (class->run)
    retval = class->run (monitor);

  return retval;
}

