/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef EFAX_CONTROLLER_H
#define EFAX_CONTROLLER_H

#include "prog_defs.h"

#include <string>
#include <vector>

#include <unistd.h>

#include <sigc++/sigc++.h>

#include "pipes.h"

bool efax_controller_childexit_handler(pid_t, int); // returns true if the pid matches that of an
                                                    // EfaxController child process, in which
                                                    // case this function will deal with it

class EfaxController: public SigC::Object {

  Pipe_fifo stdout_pipe;
  SigC::Connection stdout_connection;
  string last_file_sent;
  void join_child(void);
  void unjoin_child(void);
  void kill_child(void);
  void save_sent_fax(void);
  void cleanup_fax_send_fail(void);
  string sentfax_number;
  std::vector<std::string> state_messages;
  std::vector<std::string> make_fax(std::string);
public:
  enum {inactive, sending, receive_answer, receive_takeover, receive_standby, close_child_connections, restart_standby, send_success, send_fail, closedown};

  SigC::Signal1<void, const char*> stdout_message;
  SigC::Signal1<void, const char*> write_state;

  void timer_event(void);
  void display_state(void);
  static int get_state(void);

  bool read_pipe_slot(Glib::IOCondition);
  void stop_slot(void);

  void efax_closedown(void);
  void sendfax(std::string& file, std::string& number);
  void receive(int);
  EfaxController(void);
};

#endif
