dnl acinclude.m4 -- various bits of this have been borrowed from the m4
dnl configuration files for KDE and GNOME

AC_DEFUN([AC_INSTALL_DIRS],
[
AC_MSG_CHECKING(the fax spool directory)
dnl set up the defaults

SPOOLDIR="/var/spool/fax"
AC_ARG_WITH(spooldir,
  [  --with-spooldir=DIR     Where fax printer filter is installed (default is /var/spool/fax)],
[
if test "$withval" != "no"; dnl 
  then SPOOLDIR="$withval"
fi
])
AC_MSG_RESULT([SPOOLDIR is $SPOOLDIR])

AC_SUBST(SPOOLDIR)
])

dnl By checking for the libraries to be linked against this
dnl only checks for dynamic linking and therefore may not
dnl be very useful
AC_DEFUN([AC_CHECK_GTHREAD_HAS_PTHREADS],
[
  AC_CACHE_VAL(ac_cv_gthread_has_pthreads, [

  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(whether glib compiled against pthreads)

	GT_LIBS=`$PKG_CONFIG --libs "gthread-2.0"`

        T_STRING=${GT_LIBS%pthread*}
	if test ${#GT_LIBS} -gt ${#T_STRING}; then
	  succeeded=yes
        fi
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
    ac_cv_gthread_has_pthreads="yes"
    AC_MSG_RESULT(yes)
  else
    ac_cv_gthread_has_pthreads="no"
    AC_MSG_ERROR([glib does not appear to be compiled against pthreads])
  fi
  ])
])

AC_DEFUN([AC_CHECK_HAVE_IOS_NOCREATE],
[
  AC_MSG_CHECKING(for fstream ios::nocreate flag)
  AC_CACHE_VAL(ac_cv_have_ios_nocreate,
  [
    AC_LANG_CPLUSPLUS
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM(
      [
#include <fstream>
      ],
      [
        std::fstream strm("dummy.txt", std::ios::in | std::ios::nocreate);
      ])
    ],
    [ac_cv_have_ios_nocreate="yes"],
    [ac_cv_have_ios_nocreate="no"]
    ) dnl end AC_COMPILE_IFELSE
  ])
  AC_MSG_RESULT([$ac_cv_have_ios_nocreate])
  if test "$ac_cv_have_ios_nocreate" = "yes" ; then
     AC_DEFINE(HAVE_IOS_NOCREATE, 1, [ Define if the C++ fstream object has ios::nocreate ])
  fi 
])

AC_DEFUN([AC_CHECK_HAVE_STREAM_IMBUE],
[
  AC_MSG_CHECKING(whether streams may have a locale imbued)
  AC_CACHE_VAL(ac_cv_have_stream_imbue,
  [
    AC_LANG_CPLUSPLUS
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#include <iostream>
#include <locale>
      ],
      [
        std::cout.imbue(std::locale::classic());
      ])
    ],
    [ac_cv_have_stream_imbue="yes"],
    [ac_cv_have_stream_imbue="no"]
    ) dnl end AC_COMPILE_IFELSE
  ])
  AC_MSG_RESULT([$ac_cv_have_stream_imbue])
  if test "$ac_cv_have_stream_imbue" = "yes" ; then
     AC_DEFINE(HAVE_STREAM_IMBUE, 1, [ Define if the C++ library can imbue stream objects with a locale ])
  fi 
])

AC_DEFUN([AC_CHECK_SOCKLEN_T],
[
  AC_CHECK_TYPES(socklen_t, , ,
  [
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
  ])
])

AC_DEFUN([AC_CHECK_IN_ADDR_T],
[
  AC_CHECK_TYPES(in_addr_t, , ,
  [
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
  ])
])

AC_DEFUN([AC_CHECK_COMPILERS],
[
  AC_ARG_ENABLE(debug,[  --enable-debug 	  creates debugging code [default=no]],
  [ 
   if test $enableval = "no"; dnl 
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  dnl Just for configure --help

  dnl this prevents stupid AC_PROG_CC from adding "-g" to the default CFLAGS
  c_flags_in=$CFLAGS

  AC_PROG_CC
  AC_PROG_CPP

  CFLAGS=$c_flags_in

  if test -z "$CFLAGS"; then 
    if test "$GCC" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CFLAGS="-g $CFLAGS"
      else
        CFLAGS="-O2 $CFLAGS"
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_C_COMPILER_FLAG(g,
          [
            CFLAGS="-g $CFLAGS"
        ])
      else 
        AC_CHECK_C_COMPILER_FLAG(O2,
          [
            CFLAGS="-O2 $CFLAGS"
        ])
      fi
    fi
    AC_CHECK_C_COMPILER_FLAG(pthread,
      [
        CFLAGS="$CFLAGS -pthread"
    ])
    if test "$GCC" = "yes"; then
       CFLAGS="$CFLAGS -Wall"
    fi
  fi

  dnl this prevents stupid AC_PROG_CXX from adding "-g" to the default CXXFLAGS
  cxx_flags_in=$CXXFLAGS

  AC_PROG_CXX
  AC_PROG_CXXCPP

  CXXFLAGS=$cxx_flags_in

  if test -z "$CXXFLAGS"; then 
    if test "$GXX" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CXXFLAGS="-g $CXXFLAGS"
      else
        CXXFLAGS="-O2 $CXXFLAGS"
        if test -z "$LDFLAGS"; then 
          LDFLAGS="-s"
        fi
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_COMPILER_FLAG(g,
          [
            CXXFLAGS="-g $CXXFLAGS"
        ])
      else 
        AC_CHECK_COMPILER_FLAG(O2,
          [
            CXXFLAGS="-O2 $CXXFLAGS"
        ])
      fi
    fi

    AC_CHECK_COMPILER_FLAG(fexceptions,
      [
        CXXFLAGS="$CXXFLAGS -fexceptions"
    ])

    AC_CHECK_COMPILER_FLAG(fsigned-char,
      [
        CXXFLAGS="$CXXFLAGS -fsigned-char"
    ])

    AC_CHECK_COMPILER_FLAG(fno-check-new,
      [
        CXXFLAGS="$CXXFLAGS -fno-check-new"
    ])

    AC_CHECK_COMPILER_FLAG(pthread,
      [
        CXXFLAGS="$CXXFLAGS -pthread"
    ])

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    fi
  fi  
])

AC_DEFUN([AC_CHECK_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CXX supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_cxx_$flag_cache,
[
echo 'int main() { return 0; }' >conftest.cc
eval "ac_cv_prog_cxx_$flag_cache=no"
if test -z "`$CXX -$1 -c conftest.cc 2>&1`"; then
  if test -z "`$CXX -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_cxx_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_cxx_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CHECK_C_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CC supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_c_$flag_cache,
[
echo 'int main(void) { return 0; }' >conftest.c
eval "ac_cv_prog_c_$flag_cache=no"
if test -z "`$CC -$1 -c conftest.c 2>&1`"; then
  if test -z "`$CC -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_c_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_c_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CHECK_MKSTEMP],
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
  CFLAGS=""
  LDFLAGS=""
  LIBS=""
  AC_CHECK_FUNCS(mkstemp,,
    AC_MSG_ERROR([Library function mkstemp is required and cannot be found]))
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
])

AC_DEFUN([AC_CHECK_X11_XLIB_H],
[

  ac_cflags_safe=$CFLAGS

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then

        if $PKG_CONFIG --exists gdk-2.0; then
          CFLAGS="$CFLAGS `$PKG_CONFIG --cflags gdk-2.0`"
        fi
        if $PKG_CONFIG --exists x11; then
          CFLAGS="$CFLAGS `$PKG_CONFIG --cflags x11`"
          PKG_CHECK_MODULES(X11, x11, [:], [:])
        fi
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi
  AC_CHECK_HEADERS([X11/Xlib.h X11/XKBlib.h])

  CFLAGS=$ac_cflags_safe
])

AC_DEFUN([AC_CLOSING_MESSAGE],
[
echo
echo "    Configuration complete."
echo
echo "    To compile, enter \`make', and then enter \`make install'"
echo "      -- \`make install' must be run as root."
echo
echo "    To reconfigure, enter \`make clean' and then run \`./configure' again."
echo
])

dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN([PKG_CHECK_MODULES], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            AC_MSG_RESULT([no])
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])

dnl PKG_CHECK_VERSION does the same as PKG_CHECK_MODULES except
dnl that it does not set *_CFLAGS and *_LIBS variables
dnl PKG_CHECK_VERSION(gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
AC_DEFUN([PKG_CHECK_VERSION], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $1)

        if $PKG_CONFIG --exists "$1" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes
        else
            AC_MSG_RESULT([no])
        fi
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$2], , :, [$2])
  else
     ifelse([$3], , AC_MSG_ERROR([Library requirements ($1) not met; consider adjusting the PKG_CONFIG_PATH environment variable if 
your libraries are in a nonstandard prefix so pkg-config can find them.]), [$3])
  fi
])

AC_DEFUN([AC_CHECK_GTK_VERSION],
[
  AC_MSG_CHECKING(which version of gtk+ to compile against)

  AC_ARG_WITH(gtk-version,
  [  --with-gtk-version      whether to use gtk+2 or gtk+3 [(gtk+3, gtk+2, auto)] [[default=auto]]],
  [
    if test "x$withval" == "xgtk+2";  then
      AC_MSG_RESULT([gtk+2])
      CGU_GTK_VERSION=2
      PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0)
    elif test "x$withval" == "xgtk+3";  then
      AC_MSG_RESULT([gtk+3])
      CGU_GTK_VERSION=3
      PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.91.0)
    elif test "x$withval" == "xauto";  then
      AC_MSG_RESULT([auto])
      PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0,
      [
        CGU_GTK_VERSION=2
      ],
      [
        PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.91.0)
	CGU_GTK_VERSION=3
      ])
    else
      AC_MSG_ERROR([incorrect gtk+ version specified - should be gtk+2, gtk+3 or auto])
    fi
  ],
  [
    AC_MSG_RESULT([auto])
    PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0,
    [
      CGU_GTK_VERSION=2
    ],
    [
      PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.91.0)
      CGU_GTK_VERSION=3
    ])
  ])
])

AC_DEFUN([PKG_CHECK_DBUS_GLIB], [

  PKG_CHECK_MODULES(DBUS_GLIB, dbus-glib-1 >= 0.70,
  [
    AC_DEFINE([HAVE_DBUS_GLIB], [1], [Define to 1 if you do not have gio dbus but do have dbus-glib.])
  ],
  [
    AC_MSG_ERROR([either glib >= 2.26.0 or dbus-glib >= 0.70 required; consider adjusting the PKG_CONFIG_PATH 
environment variable if your libraries are in a nonstandard prefix so pkg-config can find them])
  ])
])

AC_DEFUN([PKG_CHECK_GIO], [

  PKG_CHECK_MODULES(GIO, gio-2.0 >= 2.26.0,
  [
    AC_DEFINE([HAVE_GIO_DBUS], [1], [Define to 1 if you have the gio dbus implementation.])
    DBUS_GLIB_CFLAGS=""
    DBUS_GLIB_LIBS=""
    AC_SUBST(DBUS_GLIB_CFLAGS)
    AC_SUBST(DBUS_GLIB_LIBS)
  ],
  [ 
    PKG_CHECK_DBUS_GLIB
  ])
])

 AC_DEFUN([AC_CHECK_CXX_GTK_UTILS],
[
  COND_INTERNAL=""
  COND_INTERNAL_LIB=""
  COND_CXXFLAG=""

  if test $CGU_GTK_VERSION -eq 2; then
    PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-1.2 >= 1.2.7,
    [
      AC_DEFINE([HAVE_CXX_GTK_UTILS], [1], [Define to 1 if you have c++-gtk-utils.])
    ],
    [
      COND_INTERNAL=c++-gtk-utils
      COND_INTERNAL_LIB=internal/c++-gtk-utils/libcxx-gtk-utils.a
      COND_CXXFLAG="-I./internal -I../internal"
    ])
  elif test $CGU_GTK_VERSION -eq 3; then
    PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-1.3 >= 1.2.7,
    [
      AC_DEFINE([HAVE_CXX_GTK_UTILS], [1], [Define to 1 if you have c++-gtk-utils.])
    ],
    [
      COND_INTERNAL=c++-gtk-utils
      COND_INTERNAL_LIB=internal/c++-gtk-utils/libcxx-gtk-utils.a
      COND_CXXFLAG="-I./internal -I../internal"
    ])
  else
    AC_MSG_ERROR([incorrect gtk+ version specified])
  fi
  AC_SUBST([COND_INTERNAL])
  AC_SUBST([COND_INTERNAL_LIB])
  AC_SUBST([COND_CXXFLAG])

  AC_MSG_CHECKING(whether the system supports monotonic clocks)
  AC_CACHE_VAL(ac_cv_have_monotonic_clock,
  [
    AC_RUN_IFELSE(
    [
      AC_LANG_PROGRAM(
      [
#include <unistd.h>
      ],
      [
        if (_POSIX_MONOTONIC_CLOCK > 0
	   && _POSIX_CLOCK_SELECTION > 0)
	   return 0;

        if (_POSIX_MONOTONIC_CLOCK == -1
	   || _POSIX_CLOCK_SELECTION == -1)
	    return -1;

        if (sysconf(_SC_MONOTONIC_CLOCK) > 0
	   && sysconf(_SC_CLOCK_SELECTION) > 0)
	   return 0;

        return -1;
      ])
    ],
    [
      ac_cv_have_monotonic_clock="yes"
    ],
    [
      ac_cv_have_monotonic_clock="no"
    ],
    [
      AC_MSG_RESULT([cross-compiling: ])
      ac_cv_have_monotonic_clock="no"
    ])
  ])

  AC_MSG_RESULT([$ac_cv_have_monotonic_clock])
  if test "$ac_cv_have_monotonic_clock" = "yes" ; then
    AC_DEFINE(HAVE_MONOTONIC_CLOCK, 1, [ Define if the system supports monotonic clocks ])
  fi

  AC_MSG_CHECKING(for sched_yield)
  AC_CACHE_VAL(ac_cv_have_sched_yield,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#include <sched.h>
      ],
      [
        sched_yield();
      ])
    ],
    [
      ac_cv_have_sched_yield="yes"
    ],
    [
      ac_cv_have_sched_yield="no"
    ])
  ])

  AC_MSG_RESULT([$ac_cv_have_sched_yield])
  if test "$ac_cv_have_sched_yield" = "yes" ; then
    AC_USE_SCHED_YIELD="define CGU_USE_SCHED_YIELD 1"
  else
    AC_USE_SCHED_YIELD="undef CGU_USE_SCHED_YIELD"
  fi 
  AC_SUBST(AC_USE_SCHED_YIELD)

  AC_MSG_CHECKING(whether headers include provision for recursive mutexes)
  AC_CACHE_VAL(ac_cv_have_recursive_mutex_headers,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#define _XOPEN_SOURCE 600
#include <pthread.h>
      ],
      [
        pthread_mutexattr_t attr;
        pthread_mutexattr_init(&attr);
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
        pthread_mutexattr_destroy(&attr);
      ])
    ],
    [
      ac_cv_have_recursive_mutex_headers="yes"
    ],
    [
      ac_cv_have_recursive_mutex_headers="no"
    ])
  ])

  AC_MSG_RESULT([$ac_cv_have_recursive_mutex_headers])
  if test "$ac_cv_have_recursive_mutex_headers" = "yes" ; then

    AC_DEFINE(HAVE_RECURSIVE_MUTEX_HEADERS, 1, [ Define if headers include provision for recursive mutexes ])

    AC_MSG_CHECKING(whether the runtime provides working recursive mutexes)
    AC_CACHE_VAL(ac_cv_have_recursive_mutex_runtime,
    [
      lib_save=$LIBS
      echo 'int main(void) { return 0; }' >conftest.c
      cgu_pthread_flag=no
      if test -z "`$CC -pthread -c conftest.c 2>&1`"; then
        if test -z "`$CC -pthread -o conftest conftest.o 2>&1`"; then
	  cgu_pthread_flag=yes
	fi
      fi
      rm -f conftest*
      if test "$cgu_pthread_flag" = "yes" ; then
        LIBS="-pthread"
	echo -n "using -pthread: "
      else
        dnl if -pthread (and so the gcc toolchain) isn't used
	dnl then -lpthread should be OK just for a run test
        LIBS="-lpthread"
      fi        
      AC_RUN_IFELSE(
      [
        AC_LANG_PROGRAM(
      	[
#define _XOPEN_SOURCE 600
#include <pthread.h>
        ],
      	[
          pthread_mutexattr_t attr;
  	  if (pthread_mutexattr_init(&attr))
    	    return -1;
  	  if (pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE)) {
    	    pthread_mutexattr_destroy(&attr);
    	    return -1;
  	  }
  	  pthread_mutexattr_destroy(&attr);
  	  return 0;
      	])
      ],
      [
        ac_cv_have_recursive_mutex_runtime="yes"
      ],
      [
        ac_cv_have_recursive_mutex_runtime="no"
      ],
      [
        AC_MSG_RESULT([cross-compiling: ])
      	ac_cv_have_recursive_mutex_runtime="no"
      ])
      LIBS=$lib_save
    ])
    
    AC_MSG_RESULT([$ac_cv_have_recursive_mutex_runtime])
    if test "$ac_cv_have_recursive_mutex_runtime" = "yes" ; then
      AC_HAVE_RECURSIVE_MUTEX_RUNTIME="define CGU_HAVE_RECURSIVE_MUTEX 1"
    else
      AC_HAVE_RECURSIVE_MUTEX_RUNTIME="undef CGU_HAVE_RECURSIVE_MUTEX"
    fi 
  else
    AC_HAVE_RECURSIVE_MUTEX_RUNTIME="undef CGU_HAVE_RECURSIVE_MUTEX"
  fi
  AC_SUBST(AC_HAVE_RECURSIVE_MUTEX_RUNTIME)

  AC_USING_NAMESPACE="// do not include using directive"
  AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT="define CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT 1"
  AC_USE_GLIB_MEMORY_SLICES_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_COMPAT"
  AC_SUBST(AC_USING_NAMESPACE)
  AC_SUBST(AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT)
  AC_SUBST(AC_USE_GLIB_MEMORY_SLICES_COMPAT)
])
