-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writers should inherit from this if they contain one widget"
	author: "Daniel Elphick <dre00r@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_bin_writer.e,v 1.8 2002/08/26 02:42:50 DJAC Exp $"

deferred class GTK_BIN_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		redefine
			append_parent_declaration, append_parent_creation, parent_inherit
		end

	CONTAINER

feature

	append_parent_declaration(code: ARRAY[STRING]) is
		do
			precursor(code)
			if last_class /= Void then
				last_class.append_parent_declaration(code)
			end
		end

	append_parent_creation(code: ARRAY[STRING]) is
			-- most will probably redefine this
		do
			if last_class /= Void then
				last_class.append_parent_creation(code)
				append_add_widget_code(code, last_class)
			end
		end

	parent_inherit: INHERIT_LIST is
		do
			if last_class /= Void then
				Result := last_class.parent_inherit
			else
				create Result.make
			end
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		do
			code.add_last(name + ".add_widget(" + widget.name + ")")
		end
end
