-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class writes the root class"
	author:			"Daniel Elphick <de397@ecs.soton.ac.uk>"
	date:          "August 1999"
	cvs:           "$Id: root_class_writer.e,v 1.15 2003/01/02 02:51:10 elphick Exp $"

class ROOT_CLASS_WRITER

inherit

	CLASS_WRITER
		rename
			widget_tree as interface
		end

creation
	make

feature
	
	name: STRING is "GTK-Interface"
	root_features: LINKED_LIST[CAN_BE_CREATED]

	inherit_from: STRING is "GNOME_APPLICATION%N%N%TGTK_APPLICATION%N%N%TTOP_LEVEL_WINDOWS%N%N%TCUSTOMISATION%N%N%TG_UTILITIES"

	make(interface_tree, project_tree: TAG_TREE; src: STRING) is
			-- Writes all the source files
		require
			valid_project: project_tree /= Void
			valid_interface: interface_tree /= Void
			valid_src: src /= Void and then not src.is_empty
		do
			src_dir := src
			classname := root_name
			filename := root_file
			interface := interface_tree
			!!root_features.make
			!!inherit_list.make
			inherit_list.add(inherit_klass)
		ensure
			interface /= Void
		end
	
	write_gtk_classes is
			-- write a class file for each widget
		local
			i: INTEGER
			cl: TAG_TREE
		do
			if interface.count = 1 then
				print("No widgets defined in interface%N")
			else
				print("Writing widget classes%N")
				from
					i := 1 -- (start from 1 because 0 is project)
						   -- this is a hack as nothing says that the project
						   -- field has to be first although it always is!
				variant
					interface.count - i
				until
					i >= interface.count
				loop
					cl ?= interface @ i
					create_child_class(cl, 0)
					inherit_list.merge_with(last_class.parent_inherit)
					root_features.add_last(last_class);
					(root_features @ i).make_top_level
					i := i + 1
				end
			end
		end

	write_features is
		do
		end

	write_make_body is
		local
			i: INTEGER
			code: ARRAY[STRING]
			s: STRING
		do
			write_line("make is")
			indent
			write_line("do")
			indent
			write_line("initialize_gnome(application_name, version)")
			write_line("set_rc_file")
			write_line("read_rc_parameters")
			from
				i := root_features.lower
			variant
				root_features.count - i
			until
				i > root_features.upper
			loop
				!!code.make(0,-1);
				(root_features @ i).append_top_level_show(code)
				write_lines(code)
				i := i + 1
			end
			write_line("begin")
			write_line("main_loop")
			outdent
			write_line("end")
			outdent
			blank_line
			write_line("read_rc_parameters is")
			indent
			write_line("local")
			indent
			write_line("filename: STRING")
			outdent
			write_line("do")
			indent
			write_line("if rc_file /= Void then")
			indent
			write_line("parse_rc_file(rc_file)")
			outdent
			write_line("end")
			write_line("!!filename.make(0)")
			write_line("filename.make_from_string(home_directory)")
			!!s.make(0)
			s.make_from_string("/.")
			s.append(clone(project_name))
			s.append("rc")
			write_line("filename.append(%"" + s + "%")")
			write_line("parse_rc_file(filename)")

			outdent
			write_line("end")
			outdent
			blank_line
			write_line("rc_file: STRING")
		end

end
