-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:   "This class writes the TOP_LEVEL_WINDOWS class"
	author:        "Oliver Elphick <olly@lfix.co.uk>"
	date:          "31 October 1999"
	cvs:           "$Id: top_level_class_writer.e,v 1.6 2002/08/26 02:43:18 DJAC Exp $"

class TOP_LEVEL_CLASS_WRITER

inherit

   CLASS_WRITER
      rename
		   widget_tree as interface
      redefine
			write_inherit, write_creation
      end

creation
	make

feature
	
	name: STRING is "GTK-Interface"
	root_features: LINKED_LIST[CAN_BE_CREATED]

	inherit_from: STRING is "GTK_APPLICATION%N%N%TTOP_LEVEL_WINDOWS%N%N%TCUSTOMISATION"

	make(interface_tree: TAG_TREE; r: LINKED_LIST[CAN_BE_CREATED];
	     src: STRING) is
			-- Writes all the source files
		require
			valid_r: r /= Void
			valid_interface: interface_tree /= Void
			valid_src: src /= Void and then not src.is_empty
		do
			src_dir := src
			generate_name("TOP_LEVEL_WINDOWS", False)
			interface := interface_tree
			root_features := r
		ensure
			interface /= Void
			root_features /= Void
		end

	write_features is
		local
			i: INTEGER
			code: ARRAY[STRING]
		do
			from
				i := root_features.lower
			variant
				root_features.count - i
			until
				i > root_features.upper
			loop
				create code.make(0,-1);
				(root_features @ i).append_top_level_definition(code)
				write_lines(code)
				i := i + 1
			end
		end

	write_make_body is
		do
		end

	write_inherit is
		do
		end

	write_creation is
		do
		end

end -- TOP_LEVEL_CLASS_WRITER
