-- Copyright (C) 1999 Didier CLERC and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkMenuBar objects"
	author: "Didier CLERC <didier-clerc@isuisse.com>"

class GTK_MENU_ITEM_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end
	
creation

	make 

feature

		
	type: STRING is
		do
			Result := "GTK_PIXMAP_MENU_ITEM"
		end

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			submenu: TAG_TREE
		do
			make_attribute(attr_name, tree, src)
			icon:= tree.get_string_from_field("icon")
			stock_icon:= tree.get_string_from_field("stock_icon")
			label := tree.get_string_from_field("label")
			right_justify := tree.get_boolean_from_field("right_justify", False)
			submenu := tree.find_child("widget")
			if submenu /= Void then
				create_child_class(submenu, 1)
			end
		end


	label: STRING
	icon : STRING
	stock_icon:STRING
	right_justify: BOOLEAN

	--in_popup: BOOLEAN

	add_common_menu_item_code(code: ARRAY[STRING]) is
		do
			if right_justify then
				code.add_last(name + ".right_justify")
			end
			add_widget_code(code)
			if last_class /= Void then
				last_class.append_parent_creation(code)
				code.add_last(name + ".set_submenu(" + last_class.name + ")")
			end
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			if label.is_empty then
				code.add_last("create " + name + ".make")
			else
				code.add_last("create " + name + ".make_with_label(%""+label+"%")")
			end
			if in_popup then
				code.add_last("Current.append(" + name + ")")
			end
			add_common_menu_item_code(code)
		end

end
