-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
-- Common elements extracted from GTK_WINDOW_WRITER and 
-- GTK_DIALOG_WRITER

indexing

   description: "Common code for GTK_WINDOW & GTK_DIALOG writers"
   author: "Oliver Elphick <olly@lfix.co.uk>"
   date: "29th April 2000"
   cvs: "$id$"

deferred class GTK_WINDOW_WRITER_COMMON

inherit

   GTK_CLASS_WRITER
      rename
	 make as make_class
      end

   SIGNAL_COMMON

feature -- attributes

   name: STRING

   title: STRING

   border_width: STRING

   allow_shrink: STRING

   allow_grow: STRING

   auto_shrink: STRING

   visible: BOOLEAN

   events: STRING

   extension_events: STRING

   wm_name: STRING

   wm_class: STRING

   width: STRING

   height: STRING

   default_width: STRING

   default_height: STRING

feature  -- common routines
	
   append_parent_declaration(code: ARRAY[STRING]) is
      do
	 code.add_last(name+": "+classname)
      end

   append_parent_creation(code: ARRAY[STRING]) is
      deferred
      end

   append_top_level_definition(code: ARRAY[STRING]) is
      do
	 code.add_last(name + ": " + classname + " is")
	 code.add_last("%Tonce")
	 code.add_last("%T%Tcreate Result.make")
	 code.add_last("%Tend%N")
      end

   append_top_level_show(code: ARRAY[STRING]) is
      do
	 if visible then
	    code.add_last(name + ".show")
	 end
      end

   make(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
      deferred
      end

   write_features is
      deferred
      end

   write_make_body is
      deferred
      end

   write_size(code: ARRAY[STRING]) is
      do
	 if width /= Void and height /= Void then
	    code.add_last("set_size(" + width + "," + height + ")")
	 end
      end

   write_make_body_common(code: ARRAY[STRING]) is
      do
	 write_line("set_title(%"" + title + "%")")
	 write_line("set_policy(" + allow_shrink + ", " +
		    allow_grow + ", " + auto_shrink + ")")
	 if border_width /= Void then
	    write_line("set_border_width("+border_width+")")
	 end
	 code.clear
	 write_size(code)
	 append_signal_code(code, "Current")
	 write_lines(code)
	 if wm_name /= Void and then wm_class /= Void then
	    write_line("set_wmclass(%"" + wm_name + "%", %"" + wm_class + "%")")
	 end
	 if default_width /= Void or default_height /= Void then
	    if default_width = Void then
	       create default_width.make_from_string("0")
	    end
	    if default_height = Void then
	       create default_height.make_from_string("0")
	    end
	    write_line("set_default_size(" + default_width + ", " + default_height + ")")
	 end
      end

   make_common(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
	 --		local
	 --			signal_trees: ARRAY[TAG_TREE]
      do
	 make_class(tree, info, src)
	 border_width := widget_tree.get_integer_string_from_field("border_width")
	 title := widget_tree.get_string_from_field("title")
	 allow_shrink := widget_tree.get_boolean_string_from_field("allow_shrink")
	 width := widget_tree.get_integer_string_from_field("width")
	 height := widget_tree.get_integer_string_from_field("height")
	 default_width := widget_tree.get_integer_string_from_field("default_width")
	 default_height := widget_tree.get_integer_string_from_field("default_height")
	 if allow_shrink = "" then
	    allow_shrink := "True"
	 end
	 allow_grow := widget_tree.get_boolean_string_from_field("allow_grow")
	 if allow_grow = "" then
	    allow_grow := "True"
	 end
	 auto_shrink := widget_tree.get_boolean_string_from_field("auto_shrink")
	 if auto_shrink = "" then
	    auto_shrink := "True"
	 end
	 wm_name := widget_tree.get_string_from_field("wmclass_name")
	 wm_class := widget_tree.get_string_from_field("wmclass_class")
	 name := clone(classname)
	 name.to_lower
	 name.prepend("instance_")
	 events := tree.get_string_from_field("events")
	 extension_events := tree.get_string_from_field("extension_events")
	 -- TODO: write the events out
	 make_signals(tree.find_children("signal"))
      end
	

end --  GTK_WINDOW_WRITER_COMMON
