// win-file.c

// Egoboo, Copyright (C) 2000 Aaron Bishop

#include "egoboo.h"

//---------------------------------------------------------------------------------------------
//File Routines-------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------

// Had to revert back to prog x code to prevent import/skin bug

void make_directory(char *dirname)
{
    // ZZ> This function makes a new directory
    _mkdir(dirname);
}

//---------------------------------------------------------------------------------------------
void remove_directory(char *dirname)
{
    // ZZ> This function removes a directory
    _rmdir(dirname);
}

//---------------------------------------------------------------------------------------------
void delete_file(char *filename)
{
    // ZZ> This function deletes a file
    remove(filename);
}

//---------------------------------------------------------------------------------------------
void copy_file(char *source, char *dest)
{
    // ZZ> This function copies a file on the local machine
    FILE* fileread;
    FILE* filewrite;
    char cTmp;


    fileread = fopen(source, "rb");
    if(fileread)
    {
        filewrite = fopen(dest, "wb");
        if(filewrite)
        {
            while(fscanf(fileread, "%c", &cTmp)!=EOF)
            {
                fprintf(filewrite, "%c", cTmp);
            }
            fclose(filewrite);
        }
        fclose(fileread);
    }
}

//---------------------------------------------------------------------------------------------
void delete_directory(char *dirname)
{
    // ZZ> This function deletes all files in a directory,
    //     and the directory itself
    char searchname[128];
    char filename[128];
    WIN32_FIND_DATA wfdData;
    HANDLE hFind;
    BOOL keeplooking;


    // Search for all files
    sprintf(searchname, "%s\\*.*", dirname);
    hFind = FindFirstFile(searchname, &wfdData);
    keeplooking = 1;
    if(hFind != INVALID_HANDLE_VALUE)
    {
        while(keeplooking)
        {
            sprintf(filename, "%s\\%s", dirname, wfdData.cFileName);
            delete_file(filename);
            keeplooking = FindNextFile(hFind, &wfdData);
        }
    }
    remove_directory(dirname);
}

//---------------------------------------------------------------------------------------------
void copy_directory(char *dirname, char *todirname)
{
    // ZZ> This function copies all files in a directory
    char searchname[128];
    char fromname[128];
    char toname[128];
    WIN32_FIND_DATA wfdData;
    HANDLE hFind;
    BOOL keeplooking;


    // Search for all files
    sprintf(searchname, "%s\\*.*", dirname);
    hFind = FindFirstFile(searchname, &wfdData);
    keeplooking = 1;
    if(hFind != INVALID_HANDLE_VALUE)
    {
        // Make the new directory
        make_directory(todirname);
        // Copy each file
        while(keeplooking)
        {
            sprintf(fromname, "%s\\%s", dirname, wfdData.cFileName);
            sprintf(toname, "%s\\%s", todirname, wfdData.cFileName);
            copy_file(fromname, toname);
            keeplooking = FindNextFile(hFind, &wfdData);
        }
    }
}

//---------------------------------------------------------------------------------------------
void empty_import_directory(void)
{
    // ZZ> This function deletes all the TEMP????.OBJ subdirectories in the IMPORT directory
    int cnt;
    char filename[256];

    cnt = 0;
    while(cnt < MAXIMPORT)
    {
        sprintf(filename, "IMPORT\\TEMP%04d.OBJ", cnt);
        delete_directory(filename);
        cnt++;
    }
}


//---------------------------------------------------------------------------------------------
//Directory Functions--------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------
WIN32_FIND_DATA win32_wfdData;
HANDLE win32_hFind;

//---------------------------------------------------------------------------------------------
// Read the first directory entry
char *DirGetFirst(char *search)
{
  win32_hFind = FindFirstFile(search, &win32_wfdData);
  return win32_wfdData.cFileName;
}

//---------------------------------------------------------------------------------------------
// Read the next directory entry (NULL if done)
char *DirGetNext(void)
{
  if(!FindNextFile(win32_hFind, &win32_wfdData)) {
    return NULL;
  }
  return win32_wfdData.cFileName;
}

//---------------------------------------------------------------------------------------------
// Close anything left open
void DirClose()
{
  FindClose( win32_hFind );
}

int ClockGetTick()
{
  return(GetTickCount());
}

int DirGetAttrib(char *fromdir)
{
  return(GetFileAttributes(fromdir));
}
