/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef LLISTA_ACL_HPP
#define LLISTA_ACL_HPP
#include <config.hpp>
#include "tipus_element_acl.hpp"
#include "cellrenderer_acl.hpp"

class ModelLlistaACL : public Gtk::TreeModel::ColumnRecord
{
	public:

		ModelLlistaACL()
		{ 
			add(iconeta);
			add(nomEntrada); 
			add(permisLectura);
			add(permisEscriptura);
			add(permisExecucio);
			add(esborrable);
			add(tipusEntrada);
			add(inefectiuLectura);
			add(inefectiuEscriptura);
			add(inefectiuExecucio);
			add(buit);
		}

		Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > iconeta;
		Gtk::TreeModelColumn<Glib::ustring> nomEntrada;
		Gtk::TreeModelColumn<bool> permisLectura;
		Gtk::TreeModelColumn<bool> permisEscriptura;
		Gtk::TreeModelColumn<bool> permisExecucio;
		Gtk::TreeModelColumn<bool> esborrable;
		Gtk::TreeModelColumn<TipusElement> tipusEntrada;
		Gtk::TreeModelColumn<bool> inefectiuLectura;
		Gtk::TreeModelColumn<bool> inefectiuEscriptura;
		Gtk::TreeModelColumn<bool> inefectiuExecucio;
		Gtk::TreeModelColumn<Glib::ustring> buit;
};

#endif
