/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef EICIEL_XATTR_WINDOW_HPP
#define EICIEL_XATTR_WINDOW_HPP

#include <config.hpp>
#include <gtkmm.h>
#include <gettext.h>
#include <sstream>
#include "gestor_xattr.hpp"
#include "llista_xattr.hpp"
#include "eiciel_xattr_controler.hpp"

class EicielXAttrControler;

class EicielXAttrWindow : public Gtk::VBox
{
	public:
		EicielXAttrWindow(EicielXAttrControler* controlador);
		virtual ~EicielXAttrWindow();

		void ompleAtributs(GestorXAttr::atributs_t llista);
		void establirNomesLectura(bool b);

		void activacio(bool b);

	private:
		EicielXAttrControler* controlador;

        Glib::RefPtr<Gtk::ListStore> refLlistaXAttr;
		ModelLlistaXAttr modelLlistaXAttr;

		Gtk::ScrolledWindow contenidorVistaLlistaXAttr;
		Gtk::TreeView vistaLlistaXAttr;

		Gtk::Button afegirAtribut;
		Gtk::Button eliminarAtribut;

		Gtk::HBox botoneraInferior;

		void canviDeSeleccioXAttr();

		void noHiHaSeleccioXAttr();
		void hiHaSeleccioXAttr();

		void nomAtributEditat(const Glib::ustring& vell, const Glib::ustring& nou);
		void valorAtributEditat(const Glib::ustring& vell, const Glib::ustring& nou);

		void eliminarAtributSeleccionat();
		void afegirAtributSeleccionat();


		bool nomesLectura;
}
;

#endif
