/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.hpp>
#include <gtkmm.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtklabel.h>
#include <libnautilus-extension/nautilus-property-page.h>
#include <libnautilus-extension/nautilus-property-page-provider.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gettext.h>

#include "eiciel_main_controler.hpp"
#include "eiciel_main_window.hpp"
#include "eiciel_nautilus_page.hpp"

#ifdef ENABLE_USER_XATTR
  #include "eiciel_xattr_controler.hpp"
  #include "eiciel_xattr_window.hpp"
#endif

struct NautilusEicielPropertiesPageDetails {
};

typedef struct {
        GObject parent;
} NautilusEicielPropertiesPageProvider;

typedef struct {
        GObjectClass parent;
} NautilusEicielPropertiesPageProviderClass;


static GObjectClass* parent_class = NULL;

static void nautilus_eiciel_property_page_provider_iface_init (NautilusPropertyPageProviderIface* iface);

static GList* nautilus_get_property_pages (NautilusPropertyPageProvider *provider,
                    GList *files);


static void nautilus_eiciel_property_page_provider_iface_init (NautilusPropertyPageProviderIface* iface)
{
	iface->get_pages = nautilus_get_property_pages;
}

static void nautilus_eiciel_properties_page_finalize (GObject* object)
{
}

void nautilus_eiciel_properties_page_class_init(NautilusEicielPropertiesPageClass* neppc)
{
	parent_class = (GObjectClass*)g_type_class_peek_parent (neppc);
	G_OBJECT_CLASS (neppc)->finalize = nautilus_eiciel_properties_page_finalize;
}


// Aquesta funci retorna una GList amb les
// pgines que proporcionarem a Nautilus
static GList* nautilus_get_property_pages (NautilusPropertyPageProvider *provider,
                    GList *files)
{
	GList *pages = NULL;
	char* uri;
	char* local_file;
	NautilusPropertyPage *real_page;
	NautilusFileInfo* file;

	// Obtenim la informaci dels fitxers i comprovem que noms s'ha
	// selleccionat un
	if (!files || files->next != NULL) 
	{
		return NULL;
	}
	file = (NautilusFileInfo*)files->data;

	// Ara obtenim la URI de Nautilus
	uri = nautilus_file_info_get_uri (file);
	GnomeVFSURI* guri = gnome_vfs_uri_new(uri);
	// i comprovem que s local
	const gchar* scheme = gnome_vfs_uri_get_scheme(guri);
	if (strcmp(scheme, "file") != 0)
	{
		g_free(guri);
		return NULL;
	}

	// Si s local obtenim el path del fitxer
	local_file = gnome_vfs_get_local_path_from_uri(uri);
	g_free(guri);

	// Alguns fitxers son locals pero no corresponen a un fitxer real
	if (local_file == NULL)
	{
		return NULL;
	}

	// Inicialitzem gtkmm
	// TODO - ?? Preguntar a la gent de gtkmm
	Gtk::Main::init_gtkmm_internals();

	// Ara creem el controlador i la vista
	EicielMainControler* main_controler = new EicielMainControler();
	EicielWindow* eiciel_window = Gtk::manage(new EicielWindow(main_controler));
	// I obrim el fitxer
	main_controler->obreFitxer(std::string(local_file));

	if (!main_controler->fitxerObert())
	{
		delete eiciel_window;
	}
	else
	{
		eiciel_window->show_all();

		real_page = nautilus_property_page_new
			("EicielPropertyPage::property_page", 
			 gtk_label_new (_("Access Control List")),
			 GTK_WIDGET(eiciel_window->gobj()));
		pages = g_list_append (pages, real_page);
	}

#ifdef ENABLE_USER_XATTR
	EicielXAttrControler* xattr_controler = new EicielXAttrControler();
	EicielXAttrWindow* xattr_window = Gtk::manage(new EicielXAttrWindow(xattr_controler));

	xattr_controler->obrirFitxer(std::string(local_file));

	if (!xattr_controler->fitxerObert())
	{
		delete xattr_window;
	}
	else
	{
		xattr_window->show_all();

		real_page = nautilus_property_page_new
			("EicielPropertyPage::property_page", 
			 gtk_label_new (_("Extended user attributes")),
			 GTK_WIDGET(xattr_window->gobj()));
		pages = g_list_append (pages, real_page);
	}
#endif
	

	g_free(local_file);

	return pages;
}

static GType nautilus_eiciel_type = 0;

static void nautilus_eiciel_register_type (GTypeModule *module)
{
	static const GTypeInfo info = {
                sizeof (NautilusEicielPropertiesPageClass),
                (GBaseInitFunc) NULL,
                (GBaseFinalizeFunc) NULL,
				(GClassInitFunc) NULL,
                // (GClassInitFunc) nautilus_eiciel_properties_page_class_init,
                NULL,
                NULL,
                sizeof (NautilusEicielPropertiesPage),
                0,
                (GInstanceInitFunc) NULL,
        };

	static const GInterfaceInfo property_page_provider_iface_info = {
		(GInterfaceInitFunc) nautilus_eiciel_property_page_provider_iface_init,
		NULL,
		NULL
	};
	
	nautilus_eiciel_type = g_type_module_register_type (module, 
						G_TYPE_OBJECT,
						"EicielNautilus",
						&info, (GTypeFlags)0);
	g_type_module_add_interface (module,
				     nautilus_eiciel_type,
				     NAUTILUS_TYPE_PROPERTY_PAGE_PROVIDER,
				     &property_page_provider_iface_info);
}

/*
 * Rutines que cridar el loader de nautilus
 */
extern void nautilus_module_initialize (GTypeModule  *module)
{
	// g_print ("Inicialitzant la pagina de propietats de Eiciel\n");
	nautilus_eiciel_register_type(module);
	// g_print ("Inicialitzacio realitzada\n");
#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
    bindtextdomain("eiciel", DATADIR "/locale");
    
    // Volem les traduccions en UTF-8 (independentment del
    // format usat per a traduir)
    bind_textdomain_codeset ("eiciel", "UTF-8");
#endif
}

/* Perform module-specific shutdown. */
extern void nautilus_module_shutdown   (void)
{
	// g_print ("Finalitzant la pagina de propietats de Eiciel\n");
}

/* List all the extension types.  */
extern void nautilus_module_list_types (const GType **types,
			    int          *num_types)
{
	static GType type_list[1];
	
	type_list[0] = nautilus_eiciel_type;

	*types = type_list;
	*num_types = 1;
}

