/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibáñez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef EICIEL_XATTR_CONTROLER_HPP
#define EICIEL_XATTR_CONTROLER_HPP

#include <sys/types.h>
#include "eiciel_xattr_window.hpp"
#include "gestor_xattr.hpp"

class EicielXAttrWindow;

class EicielXAttrControler : public sigc::trackable
{
	private:
		GestorXAttr* gestorXAttr;
		EicielXAttrWindow* finestra;
		bool _fitxerObert;

		void eliminarAtribut(const Glib::ustring& nomAtrib) throw (GestorXAttrException);

		void afegirAtribut(const Glib::ustring& nomAtrib, const Glib::ustring& valorAtrib) throw (GestorXAttrException);
		void actualitzarValorAtribut(const Glib::ustring& nomAtrib, const Glib::ustring& valorNouAtrib) throw (GestorXAttrException) ;
		void modificarNomAtribut(const Glib::ustring& nomAnticAtribut, const Glib::ustring& nomNouAtribut) throw (GestorXAttrException);

		void comprovarEditable();
	public:
		EicielXAttrControler::EicielXAttrControler();
		bool fitxerObert() { return _fitxerObert; };

		void obrirFitxer(const Glib::ustring& nomFitxer) throw (GestorXAttrException);

		friend class EicielXAttrWindow;
}
;

#endif
