#!/bin/sh
# $Id: format.sh,v 2.7 2002/05/08 15:00:56 waite Exp $
# Copyright 1990, The Regents of the University of Colorado

# This file is part of the Eli translator construction system.

# Eli is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.

# Eli is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# You should have received a copy of the GNU General Public License along
# with Eli; see the file COPYING.  If not, write to the Free Software
# Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# EXEC (format.sh) (.) (:aux_tex) (:tex_input) (:tnf)
#   => (:dvi) (:index_entries);
# :index_entries 'Index entries for this formatted file'? => :FILE;

ODIN_RUNDIR=`pwd`
PKG=$1;shift; ODIN_aux_tex=$1;shift; ODIN_tex_input=$1;shift; ODIN_e187=$1;shift;

name=`basename $ODIN_e187 .tnf`

cd "$ODIN_aux_tex"
$ODINCACHE/PKGS/info/texinfo/texindex.exe *.??
cp *.??s *.aux "$ODIN_RUNDIR"
chmod 666 "$ODIN_RUNDIR"/*.aux

cd "$ODIN_RUNDIR"

# Produce the formatted version of the document

cp "$ODINCACHE/PKGS/info/texinfo.tex" .
cp "$ODINCACHE/PKGS/info/tnf/org.tnf" .
cp "$ODINCACHE/PKGS/info/tnf/padorg.tnf" .
cp "$ODINCACHE/PKGS/info/tnf/mqorg.tnf" .
cp "$ODIN_tex_input" input.tnf

cp "$ODINCACHE/PKGS/liga/Info"/*.ps "$ODINCACHE/PKGS/liga/Info/psfig.tex" .
if (tex \\batchmode \\input input.tnf > /dev/null 2>&1)
then rm -f psfig.tex *.ps
else
	rm -f psfig.tex *.ps
	cp *.log ERRORS 
	cp /dev/null dvi
	cp /dev/null index_entries
	exit 0
fi

mv *.dvi dvi

# Merge all of the index entries together
# (for later use in production of a global index)

touch index_entries
for i in "$ODIN_RUNDIR"/*.??
do
	$ODINCACHE/PKGS/skeleton/sed.exe -e "s/}{\([0123456789]*\)}{/}{\1-${name}}{/" \
			< $i >> index_entries
done

exit 0

