#! /bin/sh

# EXEC (tex.sh) (:fmtcmd) (:rootName) (:texsp) (:tex.vtd :texauxin.vtd :vir_dir)&
#    NEEDS (:texbasis :extract=:tex) (:texbasis :extract=:sty)
#      (:tex.vtd :texauxin.vtd :vir_tgt.list)&
#    => (:dvi) (:tex.log) (:citations) (:texauxout);

ODIN_fmtcmd=$1;shift; ODIN_root=$1;shift; ODIN_search=$1;shift; ODIN_aux=$1;shift;
mkdir texauxout

for d in `cat $ODIN_search`; do sp=$sp"$d":; done
TEXINPUTS=$sp"$TEXINPUTS"; export TEXINPUTS;

if [ -d "$ODIN_aux" ]
then
  if [ "`ls $ODIN_aux`" != '' ]
  then cp $ODIN_aux/* texauxout; chmod 666 texauxout/*
  fi
fi

cd texauxout
`cat $ODIN_fmtcmd` `cat $ODIN_root`.tex </dev/null 1>../MSGS 2>&1 \
  || ( mv ../MSGS ../ERRORS; echo 'formatter failed.' >>../ERRORS )
cd ..

if [ -f texauxout/*.dvi ] ; then mv texauxout/*.dvi dvi; fi
if [ -f texauxout/*.log ]
then mv texauxout/*.log tex.log
else touch tex.log
fi

touch citations
if [ -d "$ODIN_aux" ]
then
  if [ "`ls $ODIN_aux`" != '' ]
  then
    for f in `ls texauxout/*.aux`
    do fgrep -e '\citation' -e '\bibstyle' -e '\bibdata' $f >> citations
    done
  fi
fi

if [ -d "$ODIN_aux" ] && ( diff $ODIN_aux texauxout > /dev/null )
then
  if [ -s citations -a ! \( -f texauxout/`cat $ODIN_root`.bbl \) ]
  then rm -f dvi
  fi
else rm -f dvi
fi

rm -f texauxout/*.bbl
