# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>


from twisted.trial.unittest import TestCase
from twisted.internet import task, defer

from elisa.plugins.database import video_parser

class TestVideoParser(TestCase):

    def setUp(self):
        self._parser = video_parser.VideoParser()

    def test_tvshow_regexes(self):
        episodes = [('Day.Break.S01E03.HDTV.XviD-XOR.avi',
                     ('Day.Break.', '01', '03')),
                    ('Dexter - 01x06 (HDTV-LOL) Return to Sender.avi',
                     ('Dexter -', '01', '06')),
                    ('Generation.Kill.S01E01.HDTV.XviD-0TV.avi',
                     ('Generation.Kill.', '01', '01')),
                    ('lost.305.hdtv-lol.avi',
                     ('lost', '3', '05')),
                    ('Weeds - 101.avi',
                     ('Weeds -', '1', '01')),
                    ('weeds.s02e01.vost-fr.avi',
                     ('weeds.', '02', '01')),
                    ('lost.[s3]_[e5].hdtv-lol.avi',
                     ('lost.', '3', '5')),
                    ]
        for filename, expected_results in episodes:
            match = self._parser.try_tvshow_match(filename)
            self.failUnless(match,
                            "%s should have been matched as TV show episode")
            results = match.groups()[:-1]
            self.assertEquals(results, expected_results)
