# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)


setup(name='elisa-plugin-shoutcast',
    version='0.1',
    description='SHOUTcast Internet radio',
    long_description='Browse by genre and listen to thousands of free Internet radio stations.',
    license='GPLv3',
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.conf', 'icons/*'],
                  'elisa.plugins.shoutcast.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    entry_points="""\
    [elisa.core.components.resource_provider]
    ShoutcastResource = elisa.plugins.shoutcast.shoutcast_resource:ShoutcastResource

    [elisa.core.plugin_registry]
    use = elisa.plugins.shoutcast.controller:use_me_hook
    """,
    controller_mappings=[('/poblesec/shoutcast',
                          'elisa.plugins.shoutcast.controller:ShoutcastListSwitcherController')],
    decorator_mappings=[('/poblesec/music/internet',
                         'elisa.plugins.shoutcast.controller:shoutcast_decorator')],
    cmdclass=cmdclass)
