# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.plugins.search.searcher import Searcher
from elisa.core import media_uri
from elisa.core.utils import defer

from elisa.core.resource_manager import  ResourceProviderNotFound
from elisa.plugins.poblesec.search_controller import SearcherEntry

import urllib

class YoutubeSearcher(Searcher):
    """
    This is the Searcher for youtube. It currently supports only video
    searches. Filters are ignored.
    """
    paths = ['videos']
    provider_path = "elisa.plugins.youtube.resource_provider:"\
                    "YoutubeResourceProvider"
    base_path = "http://gdata.youtube.com/feeds/api/videos?vq=%s" \
                "&max-results=50" 

    def search(self, uri, model):
        provider = self._query_provider()
        if provider is None:
            return defer.fail(ResourceProviderNotFound(self.provider_path))

        def got_videos(result_model):
            model.videos = result_model.videos
            return model

        query_string = uri.filename
        encoded_query_string = urllib.quote(query_string)
        search_uri = media_uri.MediaUri(self.base_path % encoded_query_string)
        result_model, dfr = provider.get(search_uri)
        dfr.addCallback(got_videos)
        return dfr

def video_search_result_decorator(controller):
    searcher = 'YoutubeSearcher'
    title = 'Youtube Search Results'
    icon_resource = 'elisa.plugins.poblesec.search'
    searcher_entry = SearcherEntry(searcher, title, icon_resource)
    controller.searchers.append(searcher_entry)
    return defer.succeed(None)
