# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.core.component import Component
from elisa.core import common, config

class Theme(Component):
    """
    DOCME

    @ivar config_file:   DOCME
    @type config_file:
    @cvar default_theme: DOCME
    @type default_theme:
    """

    default_theme = None

    def __init__(self):
        Component.__init__(self)
        self._config_file = None
        self._theme_config = None


    def initialize(self):
        Component.initialize(self)
        self.config_file = self.default_theme

    def config_file__get(self):
        return self._config_file

    def config_file__set(self, config_file):
        if config_file:
            self._config_file = config_file
            file_path = self._get_file_path(config_file)
            self._theme_config = config.Config(file_path)


    def _get_file_path(self, plugin_path):
        parts = plugin_path.split(':')
        if len(parts) == 2:
            plugin_name = parts[0]
            relative_path = parts[1]
            plugin_registry = common.application.plugin_registry
            root_plugin_path = plugin_registry.get_plugin_path(plugin_name)
            return root_plugin_path + "/" + relative_path
        else:
            return plugin_path

    def get_media(self, key, default_plugin_path=None):
        """
        Return the absolute path to a file in the theme.

        @param key:                 key (name) for the file 
        @type key:                  string
        @param default_plugin_path: if the theme found None, use this one
        @type default_plugin_path:  string
        @rtype:                     string
        """
        # the format of default_plugin_path is plugin:directory/file
        plugin_path = self._theme_config.get_option(key,
                                                    section='general',
                                                    default=None)

        if plugin_path==None:
            if default_plugin_path==None:
                self.debug("Couldn't find '%s' returning unknown_icon" % key)
                plugin_path = self._theme_config.get_option('unknown_icon',
                                                            section='general',
                                                            default=None)
            else:
                self._theme_config.set_option(key,
                                              default_plugin_path,
                                              section='general')
                plugin_path=default_plugin_path

        return self._get_file_path(plugin_path)


    def save_config(self, application_config):
        """
        DOCME
        """
        self._theme_config.write()
        Component.save_config(self, application_config)
