# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests import elisa_test_case
import sys, os
import inspect

class ComponentTestCase(elisa_test_case.ElisaTestCase):

    component_class = None
    component_path = '.'
    logged = False
    
    def __init__(self, methodName='runTest'):        
        elisa_test_case.ElisaTestCase.__init__(self, methodName=methodName)

        component = self.get_component()
        if component is None:
            error = "Component %r not found" % self.component_class
            self.warning(error)
            self.skip = error
        elif not self.logged:
            self.info("Testing component: %r", component)
            self.__class__.logged = True

    def get_component(self):
        component = None
        if self.component_class:
            if isinstance(self.component_class, basestring):

                # setup path
                sys_path = os.getcwd()
                if self.component_path == '.':
                    sys_path = inspect.getsourcefile(self.__class__)
                    sys_path = os.path.dirname(sys_path)
                elif self.component_path.startswith('..'):
                    sys_path = inspect.getsourcefile(self.__class__)
                    sys_path = os.path.dirname(sys_path)
                    sys_path = os.path.dirname(sys_path[:-1])
                    index = self.component_path.find(os.path.sep)
                    if index > -1:
                        dirname = self.component_path[index+1:]
                        sys_path = os.path.join(sys_path, dirname)

                self.debug('Appending %r to sys.path', sys_path)
                sys.path.insert(0, sys_path)
                        
                # import
                path = self.component_class
                mod_class = path.split(':')

                try:
                    module = __import__(mod_class[0], globals(),
                                        locals(), [mod_class[1]])
                except ImportError:
                    pass
                else:
                    Class = getattr(module, mod_class[1])
                    # avoid unecessary future imports
                    self.component_class = Class
                    component = Class()

                # clean sys path
                sys.path.remove(sys_path)
                
            else:
                component = self.component_class()

        # TODO: perform extra stuff that's normally done by the
        #       plugin registry create_component() method
        from elisa.core import common
        app = common.application
        if app:
            self.debug("Initializing %r component", component.name)
            component.load_config(app.config)
            component.initialize()
        else:
            self.debug("Application not set, skipping component initialization")
        return component

    def setUp(self):
        elisa_test_case.ElisaTestCase.setUp(self)
        self.component = self.get_component()
