#-*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.extern.translation import gettexter, N_, Translator, Translatable
T_ = gettexter('elisa-test')



class I18nTest(ElisaTestCase):


    def setUp(self):
        ElisaTestCase.setUp(self)
        self._translator = Translator()

    def test_n(self):
        text = "some like it hot"

        self.assertEquals(text, N_(text))

    def test_t(self):
        artist = T_('By Artist')
        self.assertTrue(isinstance(artist, Translatable))
        self.assertEquals(artist.domain, 'elisa-test')

    def test_translator(self):

        self._translator.addLocaleDir('elisa-test','../elisa/core/tests/data/')

        # in our test 'deu' this is 'Nach Album'
        artist = T_('By Artist')
        translated = self._translator.translateTranslatable(artist, ['deu'])
    
        # what ever it is translating: it should be unicode!
        self.assertTrue(isinstance(translated, unicode))

        # did it translate?
        self.assertEquals(translated, u'Nach Künstler')

        # in our test 'deu' this is not existing:
        dvd = T_('DVD')
        translated = self._translator.translateTranslatable(dvd, ['deu'])
        self.assertEquals(translated, 'DVD')

        # this is not existing in 'deu' but in 'deu2':
        file = T_('File device')
        translated = self._translator.translateTranslatable(file, ['deu',
                                                                    'deu2'])
        self.assertEquals(translated, 'Festplatte')

        # this is existing in the 'deu' but not in 'deu2', but that is not
        # important!
        slide = T_('Slideshow')
        translated = self._translator.translateTranslatable(slide, ['deu',
                                                                    'deu2'])
        self.assertEquals(translated, 'Diashow')

        translated = self._translator.translateTranslatable(slide, ['deu2',
                                                                    'deu'])
        self.assertEquals(translated, 'Diashow')


        # okay. lets test priorities.
        artist = T_('By Artist')
        translated = self._translator.translateTranslatable(artist, ['deu',
                                                                    'deu3'])
        self.assertEquals(translated, u'Nach Künstler')

        translated = self._translator.translateTranslatable(artist, ['deu3',
                                                                    'deu'])
        self.assertEquals(translated, u'Nach Künstler2')

        # NICE!


